#include "cips.h"

short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{

   char     name[80], name2[80], name3[80], type[80];
   int      count, i, j,
            il1, ie1, ll1, le1,
            il2, ie2, ll2, le2,
            il3, ie3, ll3, le3,
            length, lw,
            value, width;
   struct   tiff_header_struct image_header;

   my_clear_text_screen();

       /*********************************************
       *
       *   Interpret the command line parameters.
       *
       **********************************************/

   if(argc < 5){
    printf(
    "\n\nNot enough parameters:"
     "\n"
     "\n usage: boolean in-file1 in-file2 out-file "
     "type [value] [il ie]"
     "\n           or "
     "\n        boolean in-file1 out-file not value"
     "\n"
     "\n recall type: and or xor nand nor not"
     "\n              You must specify a value for "
     "nand & nor"
     "\n"
     "\n If in-file1 is only one ROWSxCOLS in size,"
     "\n then specify il ie for in-file2"
     "\n");
    exit(0);
   }

   if(strcmp("not", argv[3]) == 0){
      strcpy(name,  argv[1]);
      strcpy(name2, argv[2]);
      strcpy(type,  argv[3]);
      value =  atoi(argv[4]);
   }  /* ends if not */
   else{
      strcpy(name,  argv[1]);
      strcpy(name2, argv[2]);
      strcpy(name3, argv[3]);
      strcpy(type,  argv[4]);
      value =  atoi(argv[5]);
   }  /* ends else all other types */

   il1 = 1;
   ie1 = 1;
   ll1 = ROWS+1;
   le1 = COLS+1;

   il2 = 1;
   ie2 = 1;
   ll2 = ROWS+1;
   le2 = COLS+1;

   il3 = 1;
   ie3 = 1;
   ll3 = ROWS+1;
   le3 = COLS+1;

       /*********************************************
       *
       *   Read the input image header and setup
       *   the looping counters.
       *
       **********************************************/

   read_tiff_header(name, &image_header);

   length = (90 + image_header.image_length)/ROWS;
   width  = (90 + image_header.image_width)/COLS;
   count  = 1;
   lw     = length*width;
   printf("\nlength=%d  width=%d", length, width);

   if(length == 1   &&   
      width  == 1   &&
      strcmp("not", argv[3] != 0)){
         il2 = atoi(argv[5]);
         ie2 = atoi(argv[6]);
         il3 = il2;
         ie3 = ie2;
         ll2 = il2+ROWS;
         le2 = ie2+COLS;
         ll3 = il3+ROWS;
         le3 = ie3+COLS;
   }  /* ends if length == width == 1 */

   if(length == 1   &&   
      width  == 1   &&
      strcmp("nand", argv[4] == 0)){
         il2 = atoi(argv[6]);
         ie2 = atoi(argv[7]);
         il3 = il2;
         ie3 = ie2;
         ll2 = il2+ROWS;
         le2 = ie2+COLS;
         ll3 = il3+ROWS;
         le3 = ie3+COLS;
   }  /* ends if length == width == 1 */

   if(length == 1   &&   
      width  == 1   &&
      strcmp("nor", argv[4] == 0)){
         il2 = atoi(argv[6]);
         ie2 = atoi(argv[7]);
         il3 = il2;
         ie3 = ie2;
         ll2 = il2+ROWS;
         le2 = ie2+COLS;
         ll3 = il3+ROWS;
         le3 = ie3+COLS;
   }  /* ends if length == width == 1 */

       /*********************************************
       *
       *   Loop over the input images and
       *   apply the desired Boolean operator.
       *
       **********************************************/

   for(i=0; i<length; i++){
      for(j=0; j<width; j++){
         printf("\nrunning %d of %d", count, lw);
         count++;

            /* AND */
         if(strcmp("and", type) == 0){
            and_image(name, name2, name3,
                      the_image, out_image,
                      il1+i*ROWS, ie1+j*COLS,
                      ll1+i*ROWS, le1+j*COLS,
                      il2+i*ROWS, ie2+j*COLS,
                      ll2+i*ROWS, le2+j*COLS,
                      il3+i*ROWS, ie3+j*COLS,
                      ll3+i*ROWS, le3+j*COLS);
         }  /* ends AND operation */

            /* OR */
         if(strcmp("or", type) == 0){
            or_image(name, name2, name3,
                     the_image, out_image,
                     il1+i*ROWS, ie1+j*COLS,
                     ll1+i*ROWS, le1+j*COLS,
                     il2+i*ROWS, ie2+j*COLS,
                     ll2+i*ROWS, le2+j*COLS,
                     il3+i*ROWS, ie3+j*COLS,
                     ll3+i*ROWS, le3+j*COLS);
         }  /* ends OR operation */

            /* XOR */
         if(strcmp("xor", type) == 0){
            xor_image(name, name2, name3,
                      the_image, out_image,
                      il1+i*ROWS, ie1+j*COLS,
                      ll1+i*ROWS, le1+j*COLS,
                      il2+i*ROWS, ie2+j*COLS,
                      ll2+i*ROWS, le2+j*COLS,
                      il3+i*ROWS, ie3+j*COLS,
                      ll3+i*ROWS, le3+j*COLS);
         }  /* ends XOR operation */

            /* NAND */
         if(strcmp("nand", type) == 0){
            nand_image(name, name2, name3,
                       the_image, out_image,
                       il1+i*ROWS, ie1+j*COLS,
                       ll1+i*ROWS, le1+j*COLS,
                       il2+i*ROWS, ie2+j*COLS,
                       ll2+i*ROWS, le2+j*COLS,
                       il3+i*ROWS, ie3+j*COLS,
                       ll3+i*ROWS, le3+j*COLS,
                       value);
         }  /* ends NAND operation */

            /* NOR */
         if(strcmp("nor", type) == 0){
            nor_image(name, name2, name3,
                      the_image, out_image,
                      il1+i*ROWS, ie1+j*COLS,
                      ll1+i*ROWS, le1+j*COLS,
                      il2+i*ROWS, ie2+j*COLS,
                      ll2+i*ROWS, le2+j*COLS,
                      il3+i*ROWS, ie3+j*COLS,
                      ll3+i*ROWS, le3+j*COLS,
                      value);
         }  /* ends NOR operation */

            /* NOT */
         if(strcmp("not", type) == 0){
            not_image(name, name2,
                      the_image, out_image,
                      il1+i*ROWS, ie1+j*COLS,
                      ll1+i*ROWS, le1+j*COLS, value);
         }  /* ends NOT operation */

      }  /* ends loop over j */
   }  /* ends loop over i */
}  /* ends main  */
