#include "cips.h"

#define R             9
#define C             7
#define COUNTER_LIMIT 8
#define IE_START      7
#define VAL         200

short image[ROWS][COLS];

         /******************************
         *
         *   Define all the 9x7 arrays
         *   that contain the characters.
         *
         *******************************/

/*
NOTE: four dots (....) represents
portions of code omitted from this
printed listing -mb
*/

               ....    

short aa[R][C] = 
   { {  0,  0,  0,  0,  0,  0,  0},
     {  0,  0,  0,VAL,  0,  0,  0},
     {  0,  0,VAL,  0,VAL,  0,  0},
     {  0,VAL,  0,  0,  0,VAL,  0},
     {  0,VAL,VAL,VAL,VAL,VAL,  0},
     {  0,VAL,  0,  0,  0,VAL,  0},
     {  0,VAL,  0,  0,  0,VAL,  0},
     {  0,VAL,  0,  0,  0,VAL,  0},
     {  0,  0,  0,  0,  0,  0,  0}};

               ....

short az[R][C] = 
   { {  0,  0,  0,  0,  0,  0,  0},
     {  0,VAL,VAL,VAL,VAL,VAL,  0},
     {  0,  0,  0,  0,  0,VAL,  0},
     {  0,  0,  0,  0,VAL,  0,  0},
     {  0,  0,  0,VAL,  0,  0,  0},
     {  0,  0,VAL,  0,  0,  0,  0},
     {  0,VAL,  0,  0,  0,  0,  0},
     {  0,VAL,VAL,VAL,VAL,VAL,  0},
     {  0,  0,  0,  0,  0,  0,  0}};

               ....

main(argc, argv)
   int  argc;
   char *argv[];
{
   int    l=1, w=1;
   int    counter=0, i, j, il, ie=7, ll, le;
   struct tiff_header_struct image_header;

   my_clear_text_screen();

   if(argc < 4){
      printf("\n usage: ilabel file-name il text\n");
      exit(-1);
   }

         /******************************
         *
         *   Setup the output file.
         *
         *******************************/

   image_header.lsb            = 1;
   image_header.bits_per_pixel = 8;
   image_header.image_length   = l*ROWS;
   image_header.image_width    = w*COLS;;
   image_header.strip_offset   = 1000;

   if(does_not_exist(argv[1]))
      create_allocate_tiff_file(argv[1], 
                                &image_header, 
                                image);
   else
      read_tiff_image(argv[1], image, 1, 1, 
                      ROWS, COLS);

   il = atoi(argv[2]);

         /******************************
         *
         *   Loop through the text
         *   arguments and place the
         *   letter arrays into the
         *   image.
         *
         *******************************/

   printf("\n");
   for(i=3; i<argc; i++){
      for(j=0; j<(strlen(argv[i])); j++){

         printf("%c", argv[i][j]);
         if(argv[i][j] == 'a')
            copy_array_into_image(aa, image, il, ie);
         if(argv[i][j] == 'b')
            copy_array_into_image(ab, image, il, ie);
         if(argv[i][j] == 'c')
            copy_array_into_image(ac, image, il, ie);

                ....

         if(argv[i][j] == 'z')
            copy_array_into_image(az, image, il, ie);

                ....


         ie = ie + C;
         counter++;
         if(counter > COUNTER_LIMIT){
            ie      = IE_START;
            il      = il+R+1;
            counter = 0;
         }
      }  /* ends loop over letters in argument */
         copy_array_into_image(xx, image, il, ie);
         ie = ie + C;
         counter++;
         if(counter > COUNTER_LIMIT){
            ie      = IE_START;
            il      = il+R+1;
            counter = 0;
         }
   }  /* ends loop over arguments */

   il = 1;
   ie = 1;
   write_array_into_tiff_image(argv[1], image,
                               il, ie,
                               il+ROWS, ie+COLS);
}


copy_array_into_image(a, the_image, il, ie)
   short a[R][C], the_image[ROWS][COLS];
   int   il, ie;
{
   int i, j;
   for(i=0; i<R; i++)
      for(j=0; j<C; j++)
         the_image[il+i][ie+j] = a[i][j];

}  /* ends copy_array_into_image */

