---------- Listing 4: The file osprint.c ---------------

// osprint -- ostream::_Print(const char *, ...)
#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <ostream>

ostream& ostream::_Print(const char *code, ...)
	{	// format data for inserter
	_TRY_IO_BEGIN
	if (!opfx())
		setstate(badbit);
	else
		{	// build format and convert
		char buf[_MAX_EXP_DIG + _MAX_SIG_DIG + 16];
		char fmt[8];
		char *s = fmt;
		*s++ = '%';
		if (code[0] != ' ' && flags() & showpos)
			*s++ = '+';
		if (code[0] == 'B' && flags() & showbase
			|| code[0] == 'P' && flags() & showpoint)
			*s++ = '#';
		if (code[1] == '.')
			*s++ = '.', *s++ = '*';
		if (code[2] != ' ')
			*s++ = code[2];
		*s = code[3];
		if (flags() & uppercase && strchr("egx", *s) != 0)
			*s = toupper(*s);
		*++s = '\0';
		va_list ap;
		va_start(ap, code);
		_Pad(code, buf, vsprintf(buf, fmt, ap));
		va_end(ap);
		}
	osfx();
	_CATCH_IO_END
	return (*this);
	}

