Listing 4 - macro definitions for instantiating a type-specific wrapper
around a generic queue of void *

//
// queue7.h - macros for instantiating a wrapper
// for a generic queue of void * with an iterator
//

#include "generic.h"
#include "genq7.h"

#define queue(T) name2(T, _queue)

//
// queuedeclare
//
#define queuedeclare(T) \
class queue(T) \
    { \
public: \
    ~queue(T)(); \
    void append(const T &e); \
    void clear(); \
    int remove(T &e); \
    class iterator; \
    friend class iterator; \
    class iterator \
        { \
    public: \
        iterator(queue(T) &q); \
        T *next(); \
    private: \
        genq::iterator gqi; \
        }; \
private: \
    genq gq; \
    }; \
\
inline queue(T)::iterator::iterator(queue(T) &q) \
    : gqi(q.gq) \
    { \
    } \
\
inline T *queue(T)::iterator::next() \
    { \
    return (T *)gqi.next(); \
    } \
\
inline queue(T)::~queue(T)() \
    { \
    clear(); \
    } \
\
inline void queue(T)::append(const T &e) \
    { \
    gq.append(new T (e)); \
    }

//
// queueimplement
//
#define queueimplement(T) \
void queue(T)::clear() \
    { \
    void *p; \
    while (gq.remove(p)) \
        delete (T *)p; \
    } \
\
int queue(T)::remove(T &e) \
    { \
    void *p; \
    int rv = gq.remove(p); \
    if (rv) \
        { \
        e = *(T *)p; \
        delete (T *)p; \
        } \
    return rv; \
    }
