Listing 5 - macro definitions for instantiating a queue of T (not a
wrapper)

//
// queue8.h - generic queue (not a wrapper)
// with an iterator class
//

#include "generic.h"

#define queue(T) name2(T, _queue)

//
// queuedeclare
//
#define queuedeclare(T) \
class queue(T) \
    { \
private: \
    struct cell \
        { \
        cell(const T &e, cell *p); \
        cell *next; \
        T element; \
        }; \
    cell *first, *last; \
public: \
    queue(T)(); \
    ~queue(T)(); \
    void append(const T &e); \
    void clear(); \
    int remove(T &e); \
    class iterator; \
    friend class iterator; \
    class iterator \
        { \
    public: \
        iterator(queue(T) &q); \
        T *next(); \
    private: \
        cell *pc; \
        }; \
    }; \
\
inline queue(T)::cell::cell(const T &e, cell *p) \
    : element(e), next(p) \
    { \
    } \
\
inline queue(T)::iterator::iterator(queue(T) &q) \
    : pc(q.first) \
    { \
    } \
\
inline queue(T)::queue(T)() : first(0), last(0) \
    { \
    } \
\
inline queue(T)::~queue(T)() \
    { \
    clear(); \
    }

//
// queueimplement
//
#define queueimplement(T) \
void queue(T)::append(const T &e) \
    { \
    cell *p = new cell(e, 0); \
    if (first == 0) \
        first = p; \
    else \
        last->next = p; \
    last = p; \
    } \
\
T *queue(T)::iterator::next() \
    { \
    T *pt = 0; \
    if (pc != 0) \
        { \
        pt = &pc->element; \
        pc = pc->next; \
        } \
    return pt; \
    } \
\
void queue(T)::clear() \
    { \
    cell *p; \
    while (first != 0) \
        { \
        p = first; \
        first = first->next; \
        delete p; \
        } \
    } \
\
int queue(T)::remove(T &e) \
    { \
    if (first == 0) \
        return 0; \
    cell *p = first; \
    if ((first = first->next) == 0) \
        last = 0; \
    e = p->element; \
    delete p; \
    return 1; \
    }

