// bitstr.cpp

// The following are added to the implementation of bitstring.
// (See "Bit Manipulation in C++, Part 1", CUJ, Dec. 1993)

bitstring::bitref bitstring::operator[](size_t pos)
{
    return bitref(*this,pos);
}

bitstring::bitref::bitref(bitstring& bs_, size_t bit_)
  : bs(bs_)
{
    bit = bit_;
}

int bitstring::bitref::operator=(int val)
{
    if (val)
        bs.set(bit);
    else
        bs.reset(bit);
    return val;
}

bitstring::bitref::operator int()
{
    return bs.test(bit);
}

