#include <iostream.h>
#include "rational.h"

// Link to existing C function:
extern "C" int gcd(int, int);

// Reduce fraction lowest terms
void Rational::reduce()
{
    int g = gcd(num,den);

    if (g > 1)
    {
        num /= g;
        den /= g;
    }
}

istream& operator>>(istream& is, Rational& r)
{
    char c;

    is >> r.num >> c;
    if (c == '/')
        is >> r.den;
    else
    {
        r.den = 1;
        is.putback(c);
    }
    r.reduce();
    return is;
}

ostream& operator<<(ostream& os, const Rational& r)
{
    os << r.num << " / " << r.den;
    return os;
}

