#include <iostream.h>
class ostream;
class istream;

class Rational
{
public:
    Rational(int n = 0, int d = 1);

    // Operations for rationals
    friend Rational operator+(const Rational&, const Rational&);
    friend Rational operator-(const Rational&, const Rational&);
    friend Rational operator*(const Rational&, const Rational&);
    friend Rational operator/(const Rational&, const Rational&);
    Rational operator-() const;

    // I/O operations
    friend ostream& operator<<(ostream&, const Rational&);
    friend istream& operator>>(istream&, Rational&);

private:
    int num;
    int den;
    void reduce();
};

inline Rational::Rational(int n, int d)
{
    num = n;
    den = d;
    reduce();
}

inline Rational operator+(const Rational& a, const Rational& b)
{
    Rational r(a.num * b.den + b.num * a.den, a.den * b.den);
    r.reduce();
    return r;
}

inline Rational operator-(const Rational& a, const Rational& b)
{
    Rational r(a.num * b.den - b.num * a.den, a.den * b.den);
    r.reduce();
    return r;
}

inline Rational operator*(const Rational& a, const Rational& b)
{
    Rational r(a.num * b.num, a.den * b.den);
    r.reduce();
    return r;
}

inline Rational operator/(const Rational& a, const Rational& b)
{
    Rational r(a.num * b.den, a.den * b.num);
    r.reduce();
    return r;
}

inline Rational Rational::operator-() const
{
    return Rational(-num,den);
}

