/* soundex.c                             */
/* Program to demonstrate use of Soundex */
/* Jeff Rosen, 12/93                     */

#include <stdio.h>
#include <ctype.h>

#define MODIFIED_VERSION  /* remove for original    */

#define MAX_LENGTH    20  /* max # of char to check */
#define SOUNDEX_LENGTH 4  /* length of Soundex code */

                  /* ALPHA_OFFSET is decimal value 
           of character 'A' in ASCII character set. */
#define ALPHA_OFFSET    65

int main(int argc, char *argv[])
{
	char code[SOUNDEX_LENGTH+1];

	soundex(argv[1], code);
    printf("the code is %s \n", code);
	
    return(0);
}

int soundex(char *in_name, char *code)
{
       /* ctable contains the Soundex value of each
          letter in alphabetical order. 0 represents 
          letters which are to be ignored */

   static char ctable[]  =
       {"01230120022455012623010202"};

  char name[MAX_LENGTH+1];
  char prior = ' ', c;
  short i, y=0;

                   /* convert name to all upper case */
  for(i=0; in_name[i] && i < MAX_LENGTH; i++)
    name[i] = toupper(in_name[i]);
  name[i] = '\0';

           /* generate 1st character of Soundex code */
  code[0] = name[0];
  y=1;
  code[y] = '\0';

#ifdef MODIFIED_VERSION
  if (name[0] == 'K')              /* modifications */
    code[0] = 'C';
  else if (name[0] == 'P' && name[1] == 'H')
    code[0] = 'F';
#endif
  

  /* loop through rest of name, until code complete */
  for(i=1; name[i]; i++) {

    if (! isalpha(name[i]))      /* skip non alpha */
      continue;

                       /* skip successive occurance */
    if (name[i] == prior)  
      continue;
    prior = name[i];

                          /* lookup letter in table*/
    c = name[i] - ALPHA_OFFSET;

    if (ctable[c] == '0')    /* ignore this letter */
      continue;    

    code[y++] = ctable[c];          /* add to code */
    code[y] = '\0';

    if (strlen(code) >= SOUNDEX_LENGTH)
      break;                   /* code is complete */
  }
  while (strlen(code) < SOUNDEX_LENGTH) {
    code[y++] = '0';        /* pad code with zeros */
	code[y] = '\0';
  }

  return(0);
}
