Listing 7 - class and inline member function definitions for a generic 
queue using void * and an nested iterator class

//
// genq5.h - generic queue of void *
// with an iterator class
//

#include <iostream.h>

class genq
	{
private:
	struct cell
		{
		cell(void *e, cell *p);
		cell *next;
		void *element;
		};
	cell *first, *last;
public:
	genq();
	void append(void *e);
	int remove(void *&e);
	class iterator;
	friend class iterator;
	class iterator
		{
	public:
		iterator(genq &q);
		void *next();
	private:
		cell *pc;
		};
	};

inline genq::cell::cell(void *e, cell *p)
	: element(e), next(p)
	{
	}

inline genq::iterator::iterator(genq &q)
	: pc(q.first)
	{
	}

inline genq::genq() : first(0), last(0)
	{
	}

