Listing 3 - class and inline member function definitions for a type-safe 
queue of str wrapped around a genq

//
// strq4.h - a type-safe wrapper for
// a queue of str wrapped around a genq
//

#include "genq4.h"
#include "str.h"

class strq
	{
public:
	~strq();
	void append(const str &e);
	void apply(void f(void *e, void *a), void *args);
	void clear();
	int remove(str &e);
private:
	genq gq;
	};

inline strq::~strq()
	{
	clear();
	}

inline void strq::append(const str &e)
	{
	gq.append(new str (e));
	}

inline void strq::
apply(void f(void *e, void *a), void *args)
	{
	gq.apply(f, args);
	}


