Listing 10 - class and inline member function definitions for a type-
safe queue of str with a nested iterator class

//
// strq5.h - a type-safe queue of str
// wrapped around a genq with an iterator
//

#include "genq5.h"
#include "str.h"

class strq
	{
public:
	~strq();
	void append(const str &e);
	void clear();
	int remove(str &e);
	class iterator;
	friend class iterator;
	class iterator
		{
	public:
		iterator(strq &q);
		str *next();
	private:
		genq::iterator gqi;
		};
private:
	genq gq;
	};

inline strq::iterator::iterator(strq &q)
	: gqi(q.gq)
	{
	}

inline str *strq::iterator::next()
	{
	return (str *)gqi.next();
	}

inline strq::~strq()
	{
	clear();
	}

inline void strq::append(const str &e)
	{
	gq.append(new str (e));
	}

