Listing 5 - A test program for a queue of str implemented using genq

//
// strtst4.cpp - test genq4 using str elements
//

#include <iostream.h>

#include "showheap.h"
#include "strq4.h"

void print_str(void *e, void *args)
	{
	*(ostream *)args << ' ' << *(str *)e;
	}

inline ostream &operator<<(ostream &os, strq &q)
	{
	q.apply(print_str, &os);
	return os;
	}

#define DIM(a) (sizeof(a)/sizeof(a[0]))

void test()
	{
	char c;
	size_t qn;
	str qe;
	strq q[4];
	while (cin >> c)
		{
		showheap();
		if (c == 'q')
			break;
		if (c == 'a')
			{
			cin >> qn >> qe;
			if (qn >= DIM(q))
				cout << "no such queue\n";
			else
				q[qn].append(qe);
			}
		else if (c == 'c')
			{
			cin >> qn;
			if (qn >= DIM(q))
				cout << "no such queue\n";
			else
				q[qn].clear();
			}
		else if (c == 'r')
			{
			cin >> qn;
			if (qn >= DIM(q))
				cout << "no such queue\n";
			else if (q[qn].remove(qe))
				cout << "removed " << qe << '\n';
			else
				cout << "q[" << qn << "] is empty\n";
			}
		else
			continue;
		for (size_t i = 0; i < DIM(q); ++i)
			cout << i << ':' << q[i] << '\n';
		}
	}

int main()
	{
	showheap();
	test();
	showheap();
	return 0;
	}


