//  Listing 3
//    mobject.h
//
//  Copyright Singleton Systems Ltd 1994

#if !defined (_MOBJECT_H_)
#define _MOBJECT_H_

#if !defined (_FARHEAPB_H_)
#include    "farheapb.h"
#endif 

#define FP_MOBJECT MemoryObject FAR *
#define VP_MOBJECT MemoryObject BASED_VOID *
#define MO_BASED_VOID_FROM_LP(lp) \
                ((VP_MOBJECT) (OFFSETOF(lp)))

#if defined (_DEBUG)
#define MO_DEBUG_NEW new(THIS_FILE, __LINE__)
#else
#define MO_DEBUG_NEW new
#endif 

class FAR MemoryObject
{
friend FarHeapBlock::FarHeapBlock ();  
private: 
HGLOBAL    my_heap_block;
MemoryObject BASED_VOID * prev_mo, 
             BASED_VOID * next_mo; 
unsigned int mo_block_size;
enum flag_values {unallocated = 0, allocated = 1};

// ... debugging code not shown here 
//     due to space constraints ...

//  Functions
public:
static void FAR * AllocateBlock (int required_size);
static void ReturnBlock (void FAR * p_block);

void FAR * operator new (size_t size); 
//  standard operator new, used for derived classes.
private:
void FAR * operator new (size_t, size_t size);
//  Extended operator new, used by AllocateBlock 
//  and standard operator new

public:

// ... debugging code not shown here 
//     due to space constraints ...


void operator delete (void FAR * p_mo);
MemoryObject ();
~MemoryObject ();

private:
static FP_MOBJECT FindFreeSpace 
            (size_t size, FP_FHB & block_allocated);
void SetAllocationFlag (int flag_val);
void SetFirstMemoryObject (HGLOBAL hglob, 
                           unsigned size);

// ... code not shown here 
//     due to space constraints ...

};
