//  Listing 3
//  farheapb.h 
//
//  Copyright Singleton Systems Ltd 1994 

#if !defined (_FARHEAPB_H_)
#define _FARHEAPB_H_     

#define     FP_FHB FarHeapBlock FAR *  
#define BASED_VOID __based (void)

typedef HGLOBAL FHB_POSITION;

class CMemoryObject;

class FAR FarHeapBlock
{ 
friend class MemoryObject; 
private:
HGLOBAL my_hglobal, previous_hglobal, next_hglobal; 
DWORD fhb_block_size;

static HGLOBAL first_fhb,   //  HGLOBAL for the first
                            //  FarHeapBlock
               last_fhb;    //  HGLOBAL for the last
                            //  FarHeapBlock

enum {default_size = 4096};
MemoryObject BASED_VOID * free_list,
                            //  Start of free list of 
                            //  MemoryObjects
             BASED_VOID * end_free_list, 
                            //  Last MemoryObject in 
                            //  the free list.
             BASED_VOID * in_use_list,
                            //  First allocated 
                            //  MemoryObject  
             BASED_VOID * end_in_use_list;
                            //  Last allocated 
                            //  MemoryObject  

//    Functions
public:
void FAR * operator new (size_t size);
void operator delete (void FAR * p_fhb); 
FarHeapBlock ();
#if defined (_DEBUG)
    ~FarHeapBlock ()
        {ASSERT (in_use_list == NULL 
                 && end_in_use_list == NULL);}
#endif

DWORD FarHeapBlock::Size () const
{
ASSERT (AfxIsValidAddress 
                    (this, sizeof (FarHeapBlock)));
return fhb_block_size;
}

static DWORD DefaultSize ()
    {return default_size;}
    
static int GetCount ();
    //  Returns the number of FarHeapBlocks currently 
    //  in use
    
static FP_FHB GetHbFromHandle (HGLOBAL h);
    //  Returns a far pointer to a FarHeapBlock, 
    //  given its handle 

//    Access operations
static FHB_POSITION GetHeadPosition ()
    {return first_fhb;}

static FP_FHB GetAt (FHB_POSITION p)
    {return GetHbFromHandle (p);} 

static FP_FHB GetNext (FHB_POSITION & p);

static BOOL IsEmpty ()
    {return FarHeapBlock::first_fhb == NULL;}
};
#endif
