//  Listing 9
//  maintest.cpp
//  contains the code for the main test routines 
//  for access to the global heap
//
//  Copyright Singleton Systems Ltd 1994

#include    "stdafx.h" 
#include    "newtest.h" 
#include    "mobject.h"
#include    "farheapb.h"
#include    <iostream.h> 
#include    <fstream.h>
#include    <iomanip.h>
#include    "cmostr.h"

class FAR sort_node : public MemoryObject
{ 
private:
int value,              //  The number to sort on
    original_order;     //  The order prior to sorting
sort_node * less_equal, //  Pointer to sort_node tree
                        //  holding sort-nodes with
          * greater;    //  Pointer to sort_node tree
                        //  holding sort-nodes with 
                        //  value > this->value
char filler [1000];     //  To make a sort_node bigger
                        //  for test purposes
public:  
sort_node ();
void read_node (ifstream &in);
                        //  Reads a sort_node from <in>
void enter_item (sort_node * item);
                        //  Traverses a sort_node tree
                        //  to insert item at the right
                        //  point.
void write_node (ofstream &out);  
                        //  Writes the contents of a
                        //  sort_node to <out>
static sort_node * unlink_least_item 
        (sort_node FAR * FAR * pp_branch);
                        //  Traverses a sort_node
                        //  branch, looking for the
                        //  least item.  When the 
                        //  least item is found, it is
                        //  unlinked from the branch.
                        //  Returns a pointer to the
                        //  least item.
};

sort_node::sort_node ()
    {less_equal = greater = NULL;}

void sort_node::read_node (ifstream &file_in)
{
ASSERT (this != NULL);
int item1, item2;
file_in >> item1 >> item2; 
value = item1; original_order = item2;
}

void sort_node::write_node (ofstream &out)
{
#pragma warning (disable: 4270)
//  stop unwanted warnings from iomanip.h
ASSERT (this != NULL);
out << dec << setw (10) << value << setw (10) 
    << original_order << endl;
#pragma warning (default: 4270)
}

void sort_node::enter_item (sort_node * item)
{
if (item->value <= value)
    {
    if (less_equal == NULL)
        less_equal = item;
    else less_equal->enter_item (item);
    }
else
    {
    if (greater == NULL)
        greater = item;
    else greater->enter_item (item);
    }   
}

sort_node * sort_node::unlink_least_item 
        (sort_node FAR * FAR * pp_branch)
{
if ((*pp_branch)->less_equal != NULL)
    //  Search down the less_equal branch 
    return unlink_least_item 
                        (&((*pp_branch)->less_equal));
else
    {   //  This node is the least item, so unlink it
    sort_node * current = * pp_branch;
    * pp_branch = current->greater;
    current->less_equal = current->greater = NULL;
    return current;
    }
}

sort_node * tree = NULL; 

#define new MO_DEBUG_NEW

void CComdtestApp::DoTest ()
{
cout << "CComdtestApp::OnFileOpen () called" << endl;

CMOString * tmp_str = new CMOString ("some test text");
    {
    CMOString test = "abc";
    test = test + "def"; 
    cout << "test = " << test << endl;
    }

void FAR * p_tmp = MemoryObject::AllocateBlock (21);
MemoryObject::ReturnBlock (p_tmp); 

ifstream fin ("newtest.txt", ios::in | ios::nocreate);
ASSERT (fin.is_open());
int no_of_entries;
fin >> no_of_entries; 
ASSERT (no_of_entries >=1);
tree = new sort_node;
tree->read_node (fin);
for (int i = 2; i <= no_of_entries; i++)
    {
    sort_node * item = new sort_node;
    item->read_node (fin);
    tree->enter_item (item);
    }

CMOString * tmp_str2 = 
                new CMOString ("some more test text");

fin.close ();   
}

void CComdtestApp::OnFileClose ()
{
//  We misuse the OnFileClose function to delete the 
//  sort tree and to generate a heap report.  We do
//  not really close anything.
cout << "CComdtestApp::OnFileClose () called" << endl;
if (tree != NULL)
    {
    ofstream fout ("newrpt.txt");           
    while (tree != NULL)
        {
        sort_node * least_item = 
                sort_node::unlink_least_item (&tree);
        least_item->write_node (fout);
        delete least_item;
        }
    CComdtestApp::OnFilePrintHeapReport();    
    fout.close();
    }
}
