//  Listing 8
//  newtest.cpp 
//
//  Copyright Singleton Systems Ltd 1994 
//

#include    "stdafx.h"
#include    <iostream.h> 
#include    <fstream.h>
#include    "newtest.h"
#include    "mobject.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CComdtestApp, CWinApp)
    //{{AFX_MSG_MAP(CComdtestApp)
    ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
    ON_COMMAND(ID_FILE_CLOSE, OnFileClose)
    ON_COMMAND(ID_FILE_PRINT_HEAP_REPORT, 
               OnFilePrintHeapReport)
    //}}AFX_MSG_MAP
    // Standard file based document commands
    ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
END_MESSAGE_MAP()


//  CComdtestApp object and other globals

CComdtestApp NEAR theApp;
ostream_withassign cout; 
int out_file_count = 0;

#if defined (_DEBUG)
    CMemoryState start, end, difference;
#endif

// CComdtestApp initialization

BOOL CComdtestApp::InitInstance()
{
exit_code = 0;

// create main MDI Frame window
CMDIFrameWnd * pMainFrame = new CMDIFrameWnd;
if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
    return FALSE;
pMainFrame->ShowWindow(m_nCmdShow);
pMainFrame->UpdateWindow();
m_pMainWnd = pMainFrame;

//  Set up the cout window
coutbuf = new winstreambuf;
cout = coutbuf;
cout_window = new ostreamWnd ("cout");
cout_window->SetBufferLines (200);
coutbuf->set_stream_window (cout_window);

return TRUE;
} 

int CComdtestApp::ExitInstance ()
{
delete coutbuf;

#if defined (_DEBUG)
//  Test for memory leakage in MemoryObjects
if (!MemoryObject::MemoryHeapIsEmpty ())
    {
    TRACE0 ("Some MemoryObjects have not been "
            "deleted.  Details are:\n");
    TRACE2 ("%d object(s) remain in %d separate "
            "global memory area(s)\n", 
            MemoryObject::MemoryHeapInUseCount (),
            MemoryObject::HeapBlockInUseCount ()); 
    MemoryObject::DumpAllObjects ();
    set_exit_code (100);
    }

//  Test for memory leakage in the standard heap
end.Checkpoint ();
if (difference.Difference (start, end))
    { 
    TRACE0 ("Memory leak detected in ExitInstance!\n");
    difference.DumpStatistics ();
    set_exit_code (100);
    }
#endif
return exit_code;
}

// App command to run the dialog
void CComdtestApp::OnAppAbout()
{
    CDialog aboutDlg (IDD_ABOUTBOX);
    aboutDlg.DoModal();
}

void CComdtestApp::OnFileOpen ()
//  A convenient hook to get the test to run
{
TRY
    {DoTest ();}
CATCH (CException, e)
    {               
    AfxMessageBox ("An exception occurred while "
                   "running CComdtestApp::DoTest()");
    }    
END_CATCH   
}


void CComdtestApp::OnFilePrintHeapReport()
    {FilePrintHeapReport();}
    
//  static function to do all the work.  May also be 
//  called from inside another static function.
void CComdtestApp::FilePrintHeapReport(char * msg)
{ 
CString out_file_name = "hprpt"; 
char buf [20];
out_file_name += _itoa (out_file_count++, buf, 10);
out_file_name += ".txt";
cout << "FilePrintHeapReport() dumping to " 
     << out_file_name << endl;
ofstream fout (out_file_name);
MemoryObject::PrintHeapReport (fout, msg);
fout.close ();
}
