//  CStrWnd.h

/*
This window class is a derivation of CMDIChildWnd
which provides the following additional
functionality:

    1.  It provides a text buffer in the form of a
    CStringArray, which is displayed in the window.

    2.  Scrolling and cursor key functions are
    provided to navigate around the contents of the
    text buffer.

Derived classes must provide routines for loading
and managing the text buffer.
*/

#if !defined (_CSTRWND_H_)
#define     _CSTRWND_H_

class CStrWnd : public CMDIChildWnd
{
public:
CStrWnd (const char * window_name);

private:   

void OnDocStart (); 	// 	Called when CNTL-HOME pressed
void OnDocEnd ();       // 	Called when CNTL-END pressed

	//{{AFX_MSG(CStrWnd) 
	afx_msg void OnPaint ();
	afx_msg void OnVScroll (UINT nSBCode, UINT npos, CScrollBar * pScrollBar);
	afx_msg void OnHScroll (UINT nSBCode, UINT npos, CScrollBar * pScrollBar);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG

DECLARE_MESSAGE_MAP ();

//  Functions for accessing and managing text_buffer

public:

int BufAddAtEnd (const char * line)
    //  Adds a line to the end of text_buffer
    //  and returns its index
    {return text_buffer.Add (line);}

void UpdateScreen ();
    //  Provided for derived classes to request a
    //  screen update.  Ensures that the last line
    //  of the buffer is always on the screen.

protected:
CStringArray text_buffer;

private:
void SetVerticalScroll ();

int current_first_row;
        //  The first row of text_buffer
        //  displayed on the screen
int current_first_col;
        //  The first column of text_buffer
        //  displayed on the screen
int no_of_lines;
        //  Number of lines in the window
int no_of_chars_in_line;
        //  Max no of chars that will fit on a line
int h_scroll_flag;
        //  Non-zero if a horizontal scroll bar has
        //  been enabled.  Once enabled, the bar
        //  is  never disabled.
int length_of_longest_line;
        //  The longest line found so far in the text
        //  being displayed.  Used for horizontal
        //  scrolling control.
};
#endif
