//  ostrwnd.cpp

#include 	"stdafx.h"
#include    "ostrwnd.h"

ostreamWnd::ostreamWnd (const char * window_name)
                        : CStrWnd (window_name)
{
max_lines_in_buffer = 50;
CMenu * control_menu = GetSystemMenu (FALSE);
ASSERT (control_menu != NULL);
VERIFY (control_menu->EnableMenuItem
                    (SC_CLOSE, MF_GRAYED ) != -1);
}

BEGIN_MESSAGE_MAP (ostreamWnd, CStrWnd)   
//{{AFX_MSG_MAP(ostreamWnd)
    ON_WM_CLOSE ()
//}}AFX_MSG_MAP
END_MESSAGE_MAP ()

afx_msg void ostreamWnd::OnClose ()
    {;}
    //  Do nothing (this window should not be closed)  

void ostreamWnd::PutText (const char * buf,
                          int no_of_chars)
{
//	The window might be hidden.  If it is, unhide it, so that the 
//	output can be seen 
if (!IsWindowVisible ()) 
	{
	TRACE0 ("Unhiding the cout/cerr window\n");
	ShowWindow (SW_SHOW);
	//	We must now get an entry for the window in the WINDOWS menu.  
	//	To do this, we need to go up two parents, past the 
	//	MDIClient to the MDIFrame window.  This gets the
	//	Windows menu updated correctly
	//	To do this, we must activate this window and then 
	//	reactivate the old active window.  
	CMDIFrameWnd * w = (CMDIFrameWnd *) GetParent ()->GetParent (); 
	CMDIChildWnd * current_active = w->MDIGetActive ();
	if (current_active != NULL)
		{
		w->MDIActivate (this);
		current_active->MDIActivate (); 
		}
	}

int ub = text_buffer.GetUpperBound ();  
TRY
	{
	if (ub < 0)
    	//  text_buffer is empty so initialise it
    	//  by adding a null entry
    	{
    	text_buffer.Add ("");
    	ub = text_buffer.GetUpperBound ();
    	}
	char * ptr = (char *) buf;
	for (int i = 0; i < no_of_chars; i++)
    	{
    	if (*buf != '\n')
        	//  Append the character to the end of the
        	//  last CString in the text_buffer
        	text_buffer [ub] += *buf;
    	else
        	{
        	text_buffer.Add ("");   //  Add a new line
        	ub = text_buffer.GetUpperBound ();
        	}   
    	buf++;
    	}   
    }
CATCH(CMemoryException, cme)
	{
	AfxMessageBox ("A CMemoryException occurred in ostreamWnd::PutText",
				   MB_OK | MB_ICONSTOP);
	THROW_LAST();				    
	}
END_CATCH	    	
while (text_buffer.GetUpperBound ()
        >= max_lines_in_buffer)
    text_buffer.RemoveAt (0);
UpdateScreen ();
}
