//	Listing 3
//	strdetab.h

/*
strdetab takes a null-terminated string <in_buf>,
possibly containing tab characters and copies it to
<out_buf>, expanding the tab characters as it goes.
Copying stops when <max_line_length> characters have
been placed in <out_buf> or when <in_buf> has been
completely copied. <out_buf> is null-terminated
(the '\0' is in addition to <max_line_length>).
If <char_line_length> is not NULL, then
*char_line_length is set to the number of characters
in <out_buf> (The equivalent of <strlen>).

The way that the tabs are expanded is determined by
<no_of_tabs> and <tab_stops>.  <tab_stops> is an array
of size <no_of_tabs>, ie indexed 0 to no_of_tabs - 1.
Each entry in <tab_stops> is a tab position.
If <no_of_tabs> = 1, then the first entry in
<tab_stops> is used to specify the positions for all
tabs in the line, at intervals of tab_stops [0].

If <tab_stops> is exhausted, then tabs are replaced
by spaces.

strdetab returns a pointer to out_buf.
*/

const char * strdetab (char * out_buf,
					   const int max_line_length,
					   const char * in_buf,
					   const int no_of_tabs,
					   const int * tab_stops,
					   int * char_line_length = NULL);
