//  winstrm.cpp

#include    "stdafx.h"
#include    "winstrm.h"

winstreambuf::winstreambuf ()
    : streambuf (buffer, winstreambuf_buf_size)
{
*buffer = 0;
reset_buffer ();
stream_window = NULL;
}

int winstreambuf::sync ()
{
ASSERT (stream_window != NULL);
stream_window->PutText (pbase (), out_waiting ());
reset_buffer ();
return 0;
}

int winstreambuf::overflow (int nCh = EOF)
{
stream_window->PutText (pbase (), out_waiting ());
if (nCh != EOF)
    //  Ie nCh caused the overflow and must be output
    stream_window->PutText ((char *) &nCh, 1);
reset_buffer ();
return 0;
}
