/* clexer.h - C/C++ "lexical scanner" declarations */

/* names based on C scanner by Tony Sanders (see clexer.l) */

#ifndef CLEXER_H
#define CLEXER_H

#define MAXSTRINGLEN 4096               /* max string constant length */

extern int column;                      /* column in line */
extern int linenum;                     /* current line number */
extern char lexstringtok[];             /* contains text of string constants */
extern int lexstringtoklen;

#define DOTDOTDOT            1
#define GE                   2
#define LE                   3
#define NOTEQU               4
#define EQU                  5

#define MULTEQU              6
#define DIVEQU               7
#define MODEQU               8
#define INCEQU               9
#define DECEQU              10
#define SHIFTLEFTEQU        11
#define SHIFTRIGHTEQU       12
#define ANDEQU              13
#define OREQU               14
#define XOREQU              15

#define SHIFTLEFT           16
#define SHIFTRIGHT          17
#define INC                 18
#define DEC                 19
#define POINTS              20
#define LOGICALAND          21
#define LOGICALOR           22

#define CHAR_CONST          23
#define INTEGER_CONST       24
#define LONG_INTEGER_CONST  25
#define FLOAT_CONST         26
#define DOUBLE_CONST        27
#define STRING              28
#define IDENTIFIER          29          /* all keywords map to identifiers */
#define ERROR               30

#endif  /* CLEXER_H */
