# makefile for CUJ directory (Symantec C++ 6.00 make)
#
# usage: make all_tests
#
CCFLAGS=-d -f -mx -3
# this version of CCFLAGS compiles for debugging
#CCFLAGS=-d -f -mx -3 -g
CC=sc

LINK=link386
# this version of LINK links for CodeView (necessary for debugging)
#LINK=link386 /co /m

LIB=lib
# librarian flags: no backup, case sensitive
LIBFLAGS=/n /b

INCLUDES=complain.hpp c_failur.hpp errmgr.hpp utils.hpp

OBJS=clexer.obj complain.obj c_failur.obj errmgr.obj utils.obj

# because tsterr.exe amd tstassrt.exe are interactive, they're not run
# from within the makefile.

all_tests: tsterr.exe tstcompl.exe tstassrt.exe findmsgs.exe

cuj.lib: $(OBJS)
        $(LIB) $(LIBFLAGS) cuj.lib -+clexer;
        $(LIB) $(LIBFLAGS) cuj.lib -+complain;
        $(LIB) $(LIBFLAGS) cuj.lib -+c_failur;
        $(LIB) $(LIBFLAGS) cuj.lib -+errmgr;
        $(LIB) $(LIBFLAGS) cuj.lib -+utils;

# remove "x32.lib" if you're not using the FlashTek DOS extender, and
# "cx+" if you're not using the DOSX memory model.

tstcompl.exe: cuj.lib tstcompl.obj
        $(LINK) /noi cx+tstcompl,tstcompl,tstcompl,cuj.lib+x32.lib;

tsterr.exe: cuj.lib tsterr.obj
        $(LINK) /noi cx+tsterr,tsterr,tsterr,cuj.lib+x32.lib;

tstassrt.exe: cuj.lib tstassrt.obj
        $(LINK) /noi cx+tstassrt,tstassrt,tstassrt,cuj.lib+x32.lib;

findmsgs.exe: cuj.lib findmsgs.obj
        $(LINK) /noi cx+findmsgs,findmsgs,findmsgs,cuj.lib+x32.lib;

.cpp.obj:
        $(CC) -c $(CCFLAGS) $<

.c.obj:
        $(CC) -c $(CCFLAGS) $<

complain.obj: $(INCLUDES) complain.cpp

errmgr.obj: $(INCLUDES) errmgr.cpp

ptrstack.obj: ptrstack.hpp ptrstack.cpp

tstassrt.obj: $(INCLUDES) tstassrt.cpp

tstcompl.obj: $(INCLUDES) tstcompl.cpp

tsterr.obj: $(INCLUDES) tsterr.cpp

# the C++ scanner:

clexer.c: clexer.l
        +flex -Ist clexer.l > clexer.c

clexer.obj: clexer.c clexer.h

findmsgs.obj: findmsgs.c clexer.h
