/* utils.hpp - text and pointer manipulation utilities for error manager */

#ifndef UTILS_HPP
#define UTILS_HPP

#include <stdio.h>

/* return a count of leading blank and alphanumeric (includes '_') */
/* characters, respectively */

int skipblanks(const char *s);
int skip_ident(const char *s);

/* allocate text (using malloc). if len == 0, uses strlen() to find */
/* length; otherwise copies only that many characters. */

char *newstring(const char *s,int len = 0);

/* read "logical" line, quoting newlines if the character before them */
/* is '\\' */

void read_continued_line(FILE *f,char *line,int linelen);

/* this is a non-template version of a pointer stack (templates weren't */
/* available when I wrote it). of course, it doesn't delete anything */
/* when it's destroyed. similarly, copying just copies the pointers. */

class ptr_stack {
    public:
        ptr_stack(void);
        ptr_stack(const ptr_stack &other);
        ptr_stack &operator =(const ptr_stack &other);
        ~ptr_stack(void);
        void *push(void *op);
        long elem_count(void);          /* 0L if empty */
        void *top(void) const;          /* return top without popping */
        void *pop(void);                /* returns 0 if stack empty */
    private:
        long size,top_idx;
        void **elems;                   /* array of pointers */
};  /* end of class ptr_stack */

#endif  /* UTILS_HPP */
