Listing 7.

/* utils.hpp - text and pointer utilities */
/* utils.cpp is on the monthly source code disk */

#ifndef UTILS_HPP
#define UTILS_HPP

#include <stdio.h>

int skipblanks(const char *s);  /* returns length */
int skip_ident(const char *s);  /* returns length */

/* allocates with malloc. copies only "len" chars */
/* unless len == 0; then copies entire string */

char *newstring(const char *s,int len = 0);

/* read "logical" line, quoting newlines if the */
/* character before them is '\\' */

void read_continued_line(FILE *f,char *line,
                         int linelen);

/* non-template pointer stack. doesn't delete */
/* anything when deleted. */

class ptr_stack {
    public:
        ptr_stack(void);
        ptr_stack(const ptr_stack &other);
        ptr_stack &operator =(const ptr_stack &other);
        ~ptr_stack(void);
        void *push(void *op);
        long elem_count(void);    /* 0L if empty */
        void *top(void) const;    /* doesn't pop */
        void *pop(void);          /* 0 if empty */
    private:
        long size,top_idx;
        void **elems;
};  /* end of class ptr_stack */

#endif  /* UTILS_HPP */
