
/* Listing 1: Associative Array Header File */

#ifndef _AA_INCLUDED
#define _AA_INCLUDED

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

enum AA_KEYTYPE {STRING_KEY,BINARY_KEY};

typedef struct {
  enum AA_KEYTYPE type;
  size_t key_size;
  size_t data_size;
  void **keys;
  void **data;
  size_t current_elements;
  size_t max_elements;
  int (*hash_function)(void *,int,int,enum AA_KEYTYPE);
} AA;

#define AA_MAX_KEY_SIZE 1024
#define AA_CURRENT_SIZE(aa) (aa->max_elements)
#define AA_CURRENT_COUNT(aa) (aa->current_elements)
#define AA_ACCESS(aa_id,type,key) \
	(*((type *)aa_addr(aa_id,key)))

AA *aa_create (enum AA_KEYTYPE,size_t,
	       size_t,size_t,int (*)());
void *aa_addr(AA *,void *) ;
void aa_keys(AA *,void ***,int *);
void aa_delete(AA *,void *);
unsigned char /* BOOLEAN */ aa_defined(AA *,void *);
#endif
