/* Listing 4 */

/* decl_gen.hpp -- declarations generating file */


/* max function envelope */
#ifdef max_TYPE  /* C++ uses first parameter test */
  inline max_TYPE max(max_TYPE x, max_TYPE y)
  { return (x > y) ? x : y; }
#endif


#ifdef stack   /* open stack class envelope */

#ifndef stack_MAX_ITEMS   /* default parameters */
  #define stack_MAX_ITEMS 5U
#endif

class stack  {
    stack_ITEM * itemPtrs[stack_MAX_ITEMS];
    unsigned items;
  public:
    stack()  { items = 0U; }
    int full() { return !(stack_MAX_ITEMS - items); }
    unsigned depth()  { return items; }
    int push(stack_ITEM * itemPtr);
    stack_ITEM * top()
        { return (items? itemPtrs[items-1] : 0); }
    stack_ITEM * pop()
        { return (items? itemPtrs[--items] : 0); }
};

#endif  /* close stack class envelope */


#ifndef def_gen_cpp   /* parameter wrapup section */
  #undef max_TYPE
  #undef stack
  #undef stack_ITEM
  #undef stack_MAX_ITEMS
#endif
