/* Listing 8 */

/* def_gen.c -- definitions generating file */

#define def_gen_c
#include "decl_gen.h"
#undef def_gen_c

/* max function envelope */
#ifdef max  /* C uses function name test */
  max_TYPE max(max_TYPE x, max_TYPE y)
  { return (x > y) ? x : y; }
#endif

#ifdef stack   /* open stack struct envelope */

void stack_scope(init)(struct stack * stackPtr)
{
    if (stackPtr)
        stackPtr->items = 0U;
}

int stack_scope(full)(struct stack * stackPtr)
{
    if (stackPtr && stackPtr->items < stack_MAX_ITEMS)
        return 0;
    return 1;
}

int stack_scope(push)
    (struct stack * stackPtr, stack_ITEM * itemPtr)
{
    if (!stack_scope(full)(stackPtr) && itemPtr)  {
        stackPtr->itemPtrs[stackPtr->items++]
            = itemPtr;
        return 1;
    }
    return 0;
}

stack_ITEM * stack_scope(top)(struct stack * stackPtr)
{
    if (stackPtr && stackPtr->items)
        return stackPtr->itemPtrs[stackPtr->items-1];
    return (stack_ITEM *) 0;
}

stack_ITEM * stack_scope(pop)(struct stack * stackPtr)
{
    if (stackPtr && stackPtr->items)
        return stackPtr->itemPtrs[--stackPtr->items];
    return (stack_ITEM *) 0;
}

#endif  /* close stack struct envelope */

#undef max
#undef max_TYPE
#undef stack
#undef stack_ITEM
#undef stack_MAX_ITEMS
#undef stack_scope
