/* Listing 3 */

template <class TYPE>
inline TYPE max(TYPE x, TYPE y)
{ return (x > y) ? x : y; }

template <class ITEM, unsigned MAX_ITEMS = 5>
class stack  {
    ITEM * itemPtrs[MAX_ITEMS];
    unsigned items;
  public:
    stack()  { items = 0U; }
    int full() { return !(MAX_ITEMS - items); }
    unsigned depth()  { return items; }
    int push(ITEM * itemPtr);
    ITEM * top()
        { return (items? itemPtrs[items-1] : 0); }
    ITEM * pop()
        { return (items? itemPtrs[--items] : 0); }
};

template <class ITEM, unsigned MAX_ITEMS>
int stack<ITEM,MAX_ITEMS>::push(ITEM * itemPtr)
{
    if (!full() && itemPtr)  {
        itemPtrs[items++] = itemPtr;
        return 1;
    }
    return 0;
}

#include <iostream.h>
#include <iomanip.h>

main()
{
    stack<char> ToDo;

    ToDo.push("wash car");
    ToDo.push("cut grass");
    ToDo.push("buy groceries");
    ToDo.push("cash paycheck");
    while (ToDo.top())
        cout << ToDo.pop() << endl;

    stack<int,10U> CountDown;

    for (int i = 1; CountDown.push(new int(i)); i++);
    while (CountDown.top())  {
        cout << *CountDown.top() << " ";
        delete CountDown.pop();
    }
    cout << "Blast Off!" << endl;
    return 0;
}
