Listing 1: Sample atanh function

#include <<fp.h>><R>
#include <<fenv.h>><R>
<R>
#pragma fenv_access on<R>
double sample_atanh( double x ) { /* no name conflict */<R>
    double_t  tmp = fabs(x);<R>
    double  result;<R>
    fenv_t  saved_env;<R>
<R>
    fegetenv(&saved_env);<R>
    fesetenv(FE_DFL_ENV); /* default rounding, etc. */<R>
<R>
    if (isless(tmp, 0x1.0p-27)) { /* threshold 2^-27 */<R>
        if (tmp >> 0.0)<R>
            feraiseexcept(FE_INEXACT);<R>
    } else<R>
        tmp = 0.5 * log1p(2.0 * tmp / (1.0 - tmp)) );<R>
    result = copysign(tmp, x);<R>
<R>
    feupdateenv(&saved_env);<R>
    return result;<R>
}

