//====================== AQMSG.CPP ======================================
//  AutoQueueMessage Class Implementation File.
//  R. Scott Guthrie - Original Code Creation
//=======================================================================
#include "AQMSG.HPP"
#include <iomanip.h>

// ----- FindByNumber -----
AutoQueueMessage* AutoQueueMessage::FindByNumber(const int Number)
{ if(IsLinked())                        // If this is a queued instance...
  { AutoQueueMessage* Tmp = (AutoQueueMessage*)GetFirstNode();
    while(Tmp)                          // While there are nodes...
    { if(Tmp->Number_ == Number)        // If this is a match
        return Tmp;                     // return its address,
      Tmp = (AutoQueueMessage*)Tmp->GetNextNode(); // else, get next instance.
    }
  }
  else                                  // This is not a queued instance.
  { if(Number_ == Number)               // If this matches
      return this;                      // return its address,
  }
  return 0;                             // otherwise return 0.
}

// ----- List -----
// This method displays the contents of the list for which the current
// instance is a member.
void AutoQueueMessage::List()
{ if(IsLinked())                        // If this is a linked instance...
  { AutoQueueMessage* Tmp = (AutoQueueMessage*)GetFirstNode();
    while(Tmp)                          // As long as there are nodes...
    {                                   // display instance data.
      cout << setw(4) << Tmp->Number_ << "  \"" << Tmp->Text_ << "\"" << endl;
      Tmp = (AutoQueueMessage*)Tmp->GetNextNode();  // Next Instance...
    }
  }
  else
  { // Output a single line for the stand alone instance.
    cout << setw(4) << Number_ << "  \"" << Text_ << "\"" << endl;
  }
}
// end file AQMSG.CPP
