/* ============ */
/* uqsort.c	*/
/* ============ */
#include "defcodes.h"
#include <assert.h>
#
# undef PRIVATE
# if defined(PROFILE)
#define	PRIVATE
# else
#define	PRIVATE	static
# endif

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define	F( P )	P
# else
#	define	F( P )	()
# endif
/* INDENT OFF */

PRIVATE	void	QuickSort F((ULONG, ULONG));
extern	void	qsort F((void *, size_t, size_t,
			int (*)(const void *, const void *)));

PRIVATE	void	Swap F((void *, void *));

PRIVATE	int (*Cmpr) F((const void *, const void *));
# undef F

extern	long	SwapCtr;

static	size_t	DataWidth;
static	char	  *MyBase;
/* INDENT ON */

#define BASE(i) (MyBase + ADDR((i)-1))
#define DEC(A)	(A -= DataWidth)
#define INC(A)	(A += DataWidth)

#define ADDR(i) (ULONG)((ULONG)(i)*((ULONG)DataWidth))
#define INDEX(a)   ((ULONG)(((a) - MyBase)/DataWidth))

#define CMPR(a, b) (*Cmpr)(a, b)
#define SWAP(a, b)   Swap (a, b)

#define DATA(i) (*(ULONG *)BASE(i))

/* ==================================================================== */
/* qsort - sort elements by the Quicksort method of Robert Sedgewick	*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
void
qsort(void *Base, size_t Num, size_t Width,
    int(*Compare) (const void *, const void *))
# else
void
qsort(Base, Num, Width, Compare)
void   *Base;
size_t	Num;
size_t	Width;
int	(*Compare) ();
# endif
{
    Cmpr = Compare;
    DataWidth = Width;
    MyBase = Base;

    QuickSort((ULONG) 1, (ULONG) Num);
}
/* ==================================================================== */
/* Partition - Separates elements in array into lows and highs		*/
/* ==================================================================== */
PRIVATE	ULONG
Partition(ULONG  First, ULONG  Last)
{
    ULONG   Left, Right;		/* Selection indexes */

    char   *LeftAddr;			/* Left Selection Item	   */
    char   *RightAddr;			/* Right Selection Item    */
    char   *PivotAddr;			/* Address of Pivot Item   */

    /* ------------------------------- */
    /* Initialize selection variables. */
    /* ------------------------------- */
    Left      = First;
    LeftAddr  = BASE(Left);
    Right     = Last;
    RightAddr = BASE(Right);

    /* --------------------- */
    /* Select pivot element. */
    /* --------------------- */
    PivotAddr = RightAddr;

    while (Left < Right)
    {
	/* -------------------------------------- */
	/* Search from Left for element >  Pivot. */
	/* -------------------------------------- */
	for (; Left < Right; ++Left, INC(LeftAddr))
	{
	    if (CMPR(LeftAddr, PivotAddr) > 0)
	    {
		break;
	    }
	}

	/* --------------------------------------- */
	/* Search from Right for element <  Pivot. */
	/* --------------------------------------- */
	for (; Right > Left; --Right, DEC(RightAddr))
	{
	    if (CMPR(RightAddr, PivotAddr) < 0)
	    {
		break;
	    }
	}

	if (LeftAddr != RightAddr)
	{
	    SWAP(LeftAddr, RightAddr);

	    ++Left,  INC(LeftAddr);
	}
    }

    /* ------------------------------------------------ */
    /* At this point all elements to the right of Right */
    /* are greater than or equal to the pivot element.	*/
    /* All elements to the left of Right are less than	*/
    /* or equal to the pivot element.			*/
    /* ------------------------------------------------ */

    /* ---------------------------------------- */
    /* Move pivot element to its correct place. */
    /* ---------------------------------------- */
    if (PivotAddr != LeftAddr)
    {
	SWAP(PivotAddr, LeftAddr);
    }

    return (Left);
}
/* ==================================================================== */
/* QuickSort - executes Quicksort algorithm with Insertion Sort mop-up	*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
PRIVATE void
QuickSort(ULONG First, ULONG Last)
# else
PRIVATE void
QuickSort(First, Last)
ULONG	First;
ULONG	Last;
# endif
{
    /* ----------------------------- */
    /* Quicksort with Tail Recursion */
    /* ----------------------------- */
    while (First < Last)
    {
	ULONG   Mid;

	Mid = Partition(First, Last);

	/* ----------------------------- */
	/* Sort Smaller Partition First. */
	/* ----------------------------- */
	if (Mid - First < Last - Mid)
	{
	    QuickSort(First, Mid - 1);
	    First = Mid + 1;
	}
	else
	{
	    QuickSort(Mid + 1, Last);
	    Last = Mid - 1;
	}
    }
}
/* ==================================================================== */
/* Swap - exchanges two data elements each of DataWidth bytes		*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
PRIVATE	void
Swap(char  * Elem1, char  * Elem2)
# else
PRIVATE void
Swap(Elem1, Elem2)
char  *Elem1;
char  *Elem2;
# endif
# if !defined(MAX_SWAP)
#	define	MAX_SWAP	256
# endif
{
    extern long SwapCtr;
    extern size_t DataWidth;

    ++SwapCtr;

    /* ----------------------------- */
    /* Swap in Most Efficient Manner */
    /* ----------------------------- */
    switch (DataWidth)
    {
    case 1:
	{
	    char    OneXfer;
	    OneXfer = *Elem1;
	    *Elem1 = *Elem2;
	    *Elem2 = OneXfer;
	    break;
	}
    case 2:
	{
	    short   TwoXfer;
	    TwoXfer = *(short *) Elem1;
	    *(short *) Elem1 = *(short *) Elem2;
	    *(short *) Elem2 = TwoXfer;
	    break;
	}
    case 4:
	{
	    long    FourXfer;
	    FourXfer = *(long *) Elem1;
	    *(long *) Elem1 = *(long *) Elem2;
	    *(long *) Elem2 = FourXfer;
	    break;
	}
    default:
	{
	    char    TempBuf[MAX_SWAP];
	    size_t  CopySize, XferSize;

	    /* ---------------------------------- */
	    /* Copy as much as possible each pass */
	    /* ---------------------------------- */
	    for (XferSize = DataWidth; 0 < XferSize; XferSize -= CopySize)
	    {
		CopySize = (XferSize < sizeof(TempBuf)) ? XferSize :
		    sizeof(TempBuf);

		memcpy(TempBuf, Elem1, CopySize);
		memcpy(Elem1, Elem2, CopySize);
		memcpy(Elem2, TempBuf, CopySize);
		Elem1 += CopySize, Elem2 += CopySize;
	    }
	    break;
	}
    }
}
# if defined(TEST)
#include "tsrtdefs.h"
void
main(int argc, char **argv)
{
    SORT_TEST_STRU  SortParms;

    SortParms.argc	= argc;
    SortParms.argv	= argv;
    SortParms.SortFun	= qsort;
    SortParms.OKCodes	= (char *) NULL;
    SortParms.ExecName	= "uqsort";
    SortParms.ExecLabel = "Untoward Qsort";

    tstsort(&SortParms);
}
# endif
