// bcd.h - BCD class definition
#include <iostream.h>
typedef unsigned char BYTE;

class BCD {
  friend ostream& operator<< (ostream& , const BCD&);
  friend istream& operator>> (istream& , BCD& );
public:
  BCD(char * str = "");          // Constructor
  ~BCD() { delete []DigPairs; }; // Destructor
  BCD& operator=(const BCD&);    // Assignment
  BCD& operator+(const BCD&);    // Addition
  BCD& operator-(const BCD&);    // Subtraction
  BCD& operator-();              // Unary minus
  void BCDGet();                 // Input
  void BCDPut() const;           // Output
private:
  BYTE * DigPairs;
};

