LISTING 7 - Shows the affect of locale settings on the decimal
point character and time formatting

/* tlocale.c:   Illustrates locales -
 *
 *      Compiled in Visual C++ under Windows NT 3.5
 */

#include <locale.h>
#include <stdio.h>
#include <time.h>

void print_stuff(void);

main()
{
    /* First in the C locale */
    puts("In the C locale:");
    print_stuff();

    /* Now try German */
    puts("\nIn the German locale:");
    setlocale(LC_ALL,"german");
    print_stuff();

    /* Now try American */
    puts("\nIn the American locale:");
    setlocale(LC_ALL,"american");
    print_stuff();

    /* Now try Italian */
    puts("\nIn the Italian locale:");
    setlocale(LC_ALL,"italian");
    print_stuff();
    return 0;
}

void print_stuff(void)
{
    char text[81];
    time_t timer = time(NULL);
    struct lconv *p = localeconv();

    printf("decimal pt. == %s\n",p->decimal_point);
    printf("currency symbol == %s\n",p->int_curr_symbol);
    printf("%.2f\n",1.2);
    strftime(text,sizeof text,"%A, %B %d, %Y (%x)\n",
             localtime(&timer));
    puts(text);
}

In the C locale:
decimal pt. == .
currency symbol == 
1.20
Tuesday, January 03, 1995 (01/03/95)


In the German locale:
decimal pt. == ,
currency symbol == DEM
1,20
Dienstag, Januar 03, 1995 (03.01.95)


In the American locale:
decimal pt. == .
currency symbol == USD
1.20
Tuesday, January 03, 1995 (01/03/95)


In the Italian locale:
decimal pt. == ,
currency symbol == ITL
1,20
marted, gennaio 03, 1995 (03/01/95)

