#include "random.h"
#include "chrom.h"

#ifndef _INC_POP_
#define _INC_POP_

class CGAPopulation
{
public:
  ~CGAPopulation();
   CGAPopulation(size_t Size, size_t Length,
                 float MaxMutationRate);

   void          CreateNextGeneration(void);
   inline float  GetBestFitness(void);
   inline size_t GetGeneration(void);
   inline size_t GetPopulationSize(void);
   inline CGAChromosome* GetChromosome(size_t Idx);
   
private:
   CGAChromosome* GetParent();

   void ReplaceChromosome(CGAChromosome* Chromosome);
   void Merge(CGAChromosome* NewChromosome);
   
   size_t          m_MaxSize;
   size_t          m_CurrentSize;
   CGAChromosome** m_Data;
   size_t          m_Generation;
   float           m_MaxMutationRate;
};

float CGAPopulation::GetBestFitness(void) {
   return m_Data[0]->GetFitness();
}

size_t CGAPopulation::GetGeneration(void) {
   return m_Generation;
}

size_t CGAPopulation::GetPopulationSize(void) {
   return m_CurrentSize; 
}

CGAChromosome* CGAPopulation::GetChromosome(
   size_t Idx)
{
   return m_Data[Idx];
}

#endif
