// MODAL3, MODALDLG dynamic helper functions
//////////////////////////////////////////////////////
#include "MODALDLG.HPP"

BOOL CALLBACK _export
FindCtlsEnumProc(HWND hWnd, LPARAM l)
{
STR s(81);
HFONT _hNoBold = (HFONT)l;
GetClassName(hWnd, (char*)(const char*)s, s.space());
s.toupper();
if(s == "STATIC" || s == "BUTTON")
	SendMessage(hWnd, WM_SETFONT,
				(WPARAM)_hNoBold, 0);
return TRUE;
}

void MODALDLG::_thinFontJob()
{
LOGFONT lFont;
HFONT hF;
if(!IsWindow(_hDlg))
	return;
// Get font and create version that is not bold.
if (0 == (hF = (HFONT)SendMessage(
						GetWindow(_hDlg, GW_CHILD),
						WM_GETFONT, 0, 0L)))
	return;
if (!GetObject(hF, sizeof(LOGFONT), (LPSTR) &lFont))
	return;
lFont.lfWeight = FW_NORMAL;
if (0 == (hF = CreateFontIndirect((LPLOGFONT)
									&lFont)))
	return;
BOOL (CALLBACK *lpfnEnum)(HWND,LPARAM);
lpfnEnum = (BOOL (CALLBACK*)(HWND,LONG))
				MakeProcInstance(
					(FARPROC)FindCtlsEnumProc, _hI);
EnumChildWindows(_hDlg,
			(BOOL (CALLBACK*)(HWND,LPARAM))lpfnEnum,
			(LPARAM)hF);
FreeProcInstance((FARPROC)lpfnEnum) ;
_hThinFont = hF;
}

void MODALDLG::_centerOnScreen()
{
int xS = GetSystemMetrics(SM_CXSCREEN);
int yS = GetSystemMetrics(SM_CYSCREEN);
RECT r;
GetWindowRect(_hDlg, &r);
int w = r.right-r.left + 1;
int h = r.bottom-r.top + 1;
MoveWindow(_hDlg, (xS-w)/2, (yS-h)/2, w, h, FALSE);
}

void MODALDLG::_drawTab(LPDRAWITEMSTRUCT lpdis)
{
POINT tp[7];
RECT r = lpdis->rcItem;
RECT rF;
STR Buf(80);

BOOL bPushed = lpdis->itemState & ODS_SELECTED;
BOOL bFocus  = lpdis->itemState & ODS_FOCUS;

// This optimization still works under Win 3.1x
if(lpdis->itemAction & ODA_FOCUS && !bFocus)
	return;

// Nothing special to draw if simply pushed
if(bPushed)
	return;

FillRect(lpdis->hDC, &(lpdis->rcItem),
			(HBRUSH)GetStockObject(LTGRAY_BRUSH));
r.top++;

HPEN hPW = CreatePen(PS_SOLID, 1,
				GetSysColor(COLOR_HIGHLIGHTTEXT));

if((UINT)(-1) == lpdis->CtlID){
	tp[0].x = r.left;
	tp[1].x = r.right+1;
	tp[0].y = tp[1].y = r.bottom-2;
	Polyline(lpdis->hDC, tp, 2);

	HPEN hSav = (HPEN)SelectObject(lpdis->hDC,
								(HGDIOBJ)hPW);
	tp[0].y = tp[1].y = r.bottom-1;
	Polyline(lpdis->hDC, tp, 2);
	DeleteObject(SelectObject(lpdis->hDC, hSav));
	return;
	}

BOOL bTheOne = (lpdis->CtlID == _nActiveGroup + 3);

tp[0].x = r.left;
tp[0].y = r.bottom-2;
tp[1].x = r.left;
tp[1].y = r.top+2;
tp[2].x = r.left+2;
tp[2].y = r.top;
tp[3].x  = r.right-3;
tp[3].y  = r.top;
tp[4].x  = r.right-1;
tp[4].y  = r.top+2;
tp[5].x  = r.right-1;
tp[5].y  = r. bottom-2;

if(bTheOne){
	tp[6].x  = r.right-1;
	tp[6].y  = r. bottom-1;
	}
else{
	tp[6] = tp[0];
	}
Polyline(lpdis->hDC, tp, 7);

HPEN hSav = (HPEN)SelectObject(lpdis->hDC,
								(HGDIOBJ)hPW);
if(bTheOne){
	tp[0].x = r.left;
	tp[0].y = r.bottom-1;
	tp[1].x = r.left+1;
	tp[1].y = r.bottom-1;
	tp[2].x = r.left+1;
	tp[2].y = r.top+2;
	tp[3].x = r.left+2;
	tp[3].y = r.top+1;
	tp[4].x = r.right-2;
	tp[4].y = r.top+1;
	Polyline(lpdis->hDC, tp, 5);
	}
else{
	tp[0].x = r.left;
	tp[1].x = r.right+1;
	tp[0].y = tp[1].y = r.bottom-1;
	Polyline(lpdis->hDC, tp, 2);
	}
DeleteObject(SelectObject(lpdis->hDC, hSav));

GetWindowText(lpdis->hwndItem,
			(char*)(const char*)Buf, Buf.space());
rF.left = r.left + 1;
rF.top = r.top + 1;
rF.right = r.right + 1;
rF.bottom = r.bottom + 1;
int oldMode = SetBkMode(lpdis->hDC, TRANSPARENT);
if(bTheOne){
	COLORREF oldC = SetTextColor(lpdis->hDC,
					GetSysColor(COLOR_HIGHLIGHTTEXT));
	DrawText(lpdis->hDC, Buf, -1, &rF,
		DT_CENTER | DT_VCENTER | DT_SINGLELINE);
	SetTextColor(lpdis->hDC, oldC);
	}
DrawText(lpdis->hDC, Buf, -1, &r,
		DT_CENTER | DT_VCENTER | DT_SINGLELINE);
SetBkMode(lpdis->hDC, oldMode);
}

