Listing 5

#include <windows.h>
#include "testapp.h"
#include "testenum.h"        // Defines enum

// Inline corresponding to first DLL function
inline long MessA(HWND hWnd, int num, LPSTR name)
{ return Entry(iFunc_MessA, hWnd, num, name); }

// Inline corresponding to second DLL function
inline int MessB(HWND hWnd, LPSTR name, char ch, long blah)
{ return Entry(iFunc_MessB, hWnd, name, ch, blah); }

// Inline corresponding to third DLL function
inline char MessC(HWND hWnd, char ch)
{ return Entry(iFunc_MessC, hWnd, ch); }

// Inline corresponding to fourth DLL function
inline LPSTR MessD(HWND hWnd, LPSTR str)
{ return (LPSTR)Entry(iFunc_MessD, hWnd, str); }

int occurence = 0;
char msg_title[] = "Tester";

// Test Dialog Function
BOOL CALLBACK _export MainDlgFunc(HWND hDlg, unsigned msg,
                                  WORD wParam, LONG lParam)
{
  switch(msg) {
  case WM_INITDIALOG:
    break;
  case WM_COMMAND:
    switch(wParam) {
    case UD_TRIGGER1:
      if(MessA(hDlg, ++occurence, "Trigger 1") != 'A')
        MessageBox(hDlg, "DLL func failed", msg_title, IDOK);
      break;
    case UD_TRIGGER2:
      if(MessB(hDlg, "Trigger 2", '~', 0x33009911) != 'B')
        MessageBox(hDlg, "DLL func failed", msg_title, IDOK);
      break;
    case UD_TRIGGER3:
      if(MessC(hDlg, '$') != 'C')
        MessageBox(hDlg, "DLL func failed", msg_title, IDOK);
      break;
    case UD_TRIGGER4:
      if(lstrcmp("BlahBlahBlah", MessD(hDlg, "BlahBlahBlah")))
        MessageBox(hDlg, "DLL func failed", msg_title, IDOK);
      break;
    case IDOK:
    case IDCANCEL:
      PostMessage(hDlg, WM_CLOSE, wParam, 0L);
      return(TRUE);
    default:;
    }
    break;
  case WM_CLOSE:
    PostQuitMessage(0);
    EndDialog(hDlg, wParam);
    return(TRUE);
  default:;
  }
  return(FALSE);
}

// WinMain
int FAR PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                       LPSTR lpszCmdLine, int nCmdShow)
{
  if(hPrevInstance)                   // Only allow 1 instance
    return(0);
                                      // Link to the dll
  HANDLE hInstLib = LoadLibrary("testlib.dll");
  if(hInstLib < HINSTANCE_ERROR) {
    MessageBox(NULL, "Fatal: Cannot load library",
               msg_title, MB_OK | MB_ICONEXCLAMATION);
    return(0);
  }

  (FARPROC)Entry = GetProcAddress(hInstLib, "Entry");
  if(!Entry) {
    MessageBox(NULL, "Fatal: Cannot get proc address",
               msg_title, MB_OK | MB_ICONEXCLAMATION);
  }
  else {                              // Run the test dialog
    FARPROC lpProc;

    lpProc = MakeProcInstance((FARPROC)MainDlgFunc, hInstance);
    DialogBox(hInstance, "MainDlg", NULL, lpProc);
    FreeProcInstance(lpProc);
  }

  FreeLibrary(hInstLib);
  return(0);
}
