/*
menucat.c 9/91 FLenk
cc menucat.c -o menucat

    An rsh 'secure' way to read files.  We only allow reading of files in
    a customers own directory, or in the public areas.  If 'cat' were
    used instead of menucat, then if a rsh menu user were able
    access the command line, then any rsh legal file could be viewed,
    including the users .profile and menu.  Do not put 'cat' in the rsh
    PATH, but instead use menucat to display files.
5/1/92
    modified how we read and display file.  now use putchar instead of
    printf which might do funny things with special chars.  Also print
    octal form of unprintable chars.
9/24/92 FLenk
    modified to include access to /usr/comments where comments to
    administrators are stored.
*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>

main(argc,argv)
int argc;
char *argv[];
{
    FILE *filein;
    char filein_nm[60];
    int c;

    strcpy(filein_nm,argv[1]);

    /*check to make sure this file is in a safe directory for customers*/
    /*Add legal directories to this program when necessary.*/
    if((strchr(filein_nm,'/')) != NULL ) { /* is there a slash in path? */
        /* then only the following directories are legal to read from */
        if( (strncmp(filein_nm,"/usr/public/",12) != 0) &&
            (strncmp(filein_nm,"/usr/spool/uucppublic/",22) != 0) &&
            (strncmp(filein_nm,"/usr/comments/",14) != 0) &&
            (strncmp(filein_nm,"/tmp/",5) != 0)  ) {
            printf("\r\nSorry.  No permission to read %s.\r\n",filein_nm);
            return 1;
        }
    }


    /*make sure file exists and user otherwise has permission*/
    if((filein=fopen(filein_nm,"r"))==NULL) {
        printf("Cannot open file: '%s'.  (permission? exist?)\r\n",filein_nm);
        return 1;
    }

    /*OK to read file*/
    while((c=fgetc(filein)) != EOF) {
        /*printf("%c",c);*/
        /*5/1/92 modified display routine*/
        if(isascii(c) && (isprint(c) || c=='\n' || c=='\t' || c==' '))
            putchar(c);
        else
            printf("\\%03o",c); /*use octal form for unprintable chars*/
    }

    fclose(filein);
    return 0;
}
/*end menucat.c*/
