/*
termlock.c
cc termlock.c -o termlock

  Terminal locking program.
  Prompts for name and password, then locks terminal until correct password
  is entered.  Redisplays every HOW_MANY_MINUTES to bypass idleout programs
  which depend on the /dev/tty time stamp (most of them) for tty activity.
  After MAXLOCK minutes, termlock removes user from system by killing
  user's processes.  Termlock displays the number of incorrect password
  attempts.



FLenk 10/15/90
3/31/91 Made a timer that redisplays screen every "delay" seconds.
 This way, our camper routine doesnt include termlock users as
 campers.
6/27/91 FL  Original had a few bugs, like double displaying the
 screen on time out.  Also added display of how many minutes
 we've been secured, and how many attempts to enter password.
 Bugs included funcky bracing in loops, bad return from main.
9/25/91 incremented HOW_MANY_MINUTES to 5 from 1
12/10/91 removed one of the beeps and added no power off warning.
 Also incremented HOW_MANY_MINUTES from 5 to 10.  Changed screen picture
 a bit.
7/14/92 FL decremented HOW_MANY_MINUTES from 10 to 1, and added a MAXLOCK
 time limit for termlock to work, at which time it will terminate the
 user's process group id, removing the user from the system.  Also,
 due to frequency of display, removed the beep at the
 Enter Password prompt.
11/10/93 FL enhanced blinking text by using popen() to get the terminal
 control commands stuffed into a string.  Used to use a system("tput..
 call for each line.  New method really speeds up display.  Thanks to
 Ed Schaefer in July/August 1993 SysAdmin for Unix pipe tips.
*/

#ident "@(#) termlock  Terminal Locking Program. Fred Lenk 11/10/93."
#include <stdio.h>
#include <signal.h>
#define HOW_MANY_MINUTES 1      /*screen refresh rate*/
#define MAXLOCK 2 /*debug & test*/
/*#define MAXLOCK 60*/       /*max minutes to stay locked*/

static char version[]=" v. 11/10/93 fgl";
char firstname[50];
int minutes;
int attempts=0;
int validentry=0;
char bufblink[51], bufnorm[51];

main()
{

char passbuf1[9],passbuf2[9],passwd[9],*getpass();
int pagree=0;
int i;
int delay=HOW_MANY_MINUTES*60;
int flag=0;
int printscr();
int blink();
int norm();
char *fgets();
FILE *ptr, *popen();


if((ptr=popen("tput blink", "r")) == NULL)
    perror("Couldn't open pipe.");
if(fgets(bufblink,50,ptr) == NULL)
    perror("Couldn't get blink terminal command.\n");
fclose(ptr);

if((ptr=popen("tput sgr0", "r")) == NULL)
    perror("Couldn't open pipe.");
if(fgets(bufnorm,50,ptr) == NULL)
    perror("Couldn't get sgr0 terminal command.\n");
fclose(ptr);

printf("         Please enter your first name: ");
gets(firstname);
while (! validentry) {
    while (! pagree) {
        strcpy(passbuf1,getpass("\r\nEnter password (4 characters minimum): "));
        strcpy(passbuf2,getpass("                Double check password: "));
        if((strcmp(passbuf1,passbuf2)) == 0)
            pagree++; /*passwords agree*/
        else
            printf("\r\nPasswords do not agree.  Try again.\r\n");
    }/*end while ! pagree*/

    if(strlen(passbuf1) < 4) {
        printf("Please enter at least 4 characters.\r\n");
        pagree=0; /*password less than 4 characters*/
    } else {
        validentry++;
    }
}/*end while ! validentry*/

/*Comment next 2 lines when debugging or you cant get out!.  Prevents*/
/*use of Unix DEL function to kill the termlock.*/
signal(SIGINT, SIG_IGN);
signal(SIGQUIT,SIG_IGN);

printscr();

validentry=0;
strcpy(passwd,"");
minutes=HOW_MANY_MINUTES;
while(! validentry) {
    if(strcmp(passwd,"") !=0) printscr();
    strcpy(passwd,"");
    signal(SIGALRM,printscr); /*reprints screen and checks for password*/
    alarm(delay);
    strcpy(passwd,getpass(""));
    if(strcmp(passwd,passbuf1) == 0) {
        validentry=1;
    }
    if(passwd[0] != '\0') {
        attempts++;
        minutes-=HOW_MANY_MINUTES;
    }
}
return;
} /* end of main */

int norm(string)
char *string;
{
    printf("%s%s",bufnorm,string);
    if(minutes==MAXLOCK)
        printf("%c",7); /*sound alarm*/
    return;
}
int blink(string)
char *string;
{
    printf("%s%s",bufblink,string);
    if(minutes==MAXLOCK)
        printf("%c",7); /*sound alarm*/
    return;
}

int printscr()
{
int i;

    minutes+=HOW_MANY_MINUTES;
    /*put a message on screen before terminating user's login session.*/
    if(minutes > MAXLOCK) {
        printf("\r\nTERMLOCK Timed Out after %d minutes.  User removed from system.\r\n",MAXLOCK);
        kill(getpgrp(),SIGKILL);
        exit(1);
    }
    /*remove following comments to disallow too many passwd tries*/
    /*
    if(attempts > 4) {
        printf("\r\nToo many password attempts.  Bye!\r\n");
        kill(getpgrp(),SIGKILL); /*detach terminal*/
        exit(1);
    }
    */

    norm("\r\n");
    printf("                                  %s \r\n",version);
    for(i=1;i<13;i++) {
        norm("                                        ^\r\n");
        norm("                                        |\r\n");
    }
    for(i=1;i<10;i++) {
        norm("\r\n");
    }

    /* need to use tput blink at every line for terminals that clear all*/
    /* attributes at the end of line such as HPs.  The following blink()*/
    /* statements produce the large word "SECURED" as produced by banner(C).*/
    blink("      #####    #######    #####    #     #   ######    #######   ######\r\n");
    blink("     #     #   #         #     #   #     #   #     #   #         #     #\r\n");
    blink("     #         #         #         #     #   #     #   #         #     #\r\n");
    blink("      #####    #####     #         #     #   ######    #####     #     #\r\n");
    blink("           #   #         #         #     #   #   #     #         #     #\r\n");
    blink("     #     #   #         #     #   #     #   #    #    #         #     #\r\n");
    blink("      #####    #######    #####     #####    #     #   #######   ######\r\n");

    norm("");
    norm("\r\n\r\n");
    norm("                           DO NOT POWER OFF TERMINAL UNTIL\r\n");
    norm("                           TERMINAL HAS BEEN UNSECURED!\r\n");
    norm("\r\n");
    printf("                           Terminal locked by %s.\r\n",firstname);
    printf("                           Terminal locked for %d minutes\r\n",minutes);
    printf("                           Terminal will disconnect in %d minutes.\r\n",MAXLOCK - minutes);
    printf("                           Password attempts: %d\r\n",attempts);
    if(minutes==MAXLOCK)
        blink("                           TERMINAL WILL DISCONNECT MOMENTARILY!\r\n");

    norm("                           Enter Password: ");
    return;

}
/*end termlock.c*/
