#include "passwd.h"

#ifdef CHFN

/*
 * change the gecos field
 */
chfn(p)
struct passwd *p;		/* pointer to password structure */
{
	char buf[BUFSIZ];		/* buffer for new shell */
	char prfmt[BUFSIZ];		/* printf format from field */
	char list[BUFSIZ];		/* order to print things */
	register char *s;		/* pointer to system shells */
	char addr1[GECOSSIZE], addr2[GECOSSIZE], addr3[GECOSSIZE];
	char addr4[GECOSSIZE], addr5[GECOSSIZE], addr6[GECOSSIZE];
	char addr7[GECOSSIZE], addr8[GECOSSIZE], addr9[GECOSSIZE];
	char *addrs[9];
	FILE *fp;
	register int i;
	int doit;

	/*
	 * initialize the reading arrays
	 */
	addrs[0] = addr1; addrs[1] = addr2; addrs[2] = addr3;
	addrs[3] = addr4; addrs[4] = addr5; addrs[5] = addr6;
	addrs[6] = addr7; addrs[7] = addr8; addrs[8] = addr9;

	/*
	 * print instructions
	 */
	PRINTF("Changing finger information for %s.\n", p->pw_name);
	PRINTF("Default values are printed inside of '[]'.\n");
	PRINTF("To accept the default, type <return>.\n");
	PRINTF("To have a blank entry, type the word 'none'.\n");

	/*
	 * open the test file
	 */
	if ((fp = fopen(pwtest, "r")) == FI_NULL){
		if (errno < sys_nerr){
			LOG2(LG_SYSTEM, "%s: %s", pwtest, sys_errlist[errno]);
		}
		else{
			LOG2(LG_SYSTEM, "%s: unknown error #%d",
							pwtest, errno);
		}
		perror("password format file");
		exit(1);
	}

	/*
	 * find and load the current information
	 */
	doit = 0;
	linect = 0;
	while(fgets(buf, BUFSIZ, fp) != NULL){
		/*
		 * kill the newline if any
		 */
		if (*(s = &buf[strlen(buf)-1]) == '\n')
			*s = '\0';
			linect++;
		/*
		 * look for the magic key words
		 */
		if (strncmp(buf, "PROMPT:", 7) == 0){
			getprompt(&buf[7]);
			continue;
		}
		if (strncmp(buf, "GECOS:", 6) == 0){
			(void) loadgecos(&buf[6], prfmt, list);
			continue;
		}
		if (strncmp(buf, "SETGECOS:", 9) == 0){
			/*
			 * now load the information
			 */
			if (loadgecos(&buf[6], prfmt, list) >= 0){
				doit = 1;
				break;
			}
		}
		/*
		 * force this format
		 */
		if (strncmp(buf, "FORCEGECOS:", 11) == 0){
			if (forcegecos(&buf[11], prfmt, list) >= 0)
				doit = 1;
			break;
		}
	}

	/*
	 * be sure you can do something
	 */
	if (doit == 0){
		(void) strcmp(prfmt, "%s,%s,%s");
		(void) strcpy(list, "not");
	}

	/*
	 * have the user update it
	 */
	for(i = 0; list[i] != '\0'; i++){
		/*
		 * ask for update
		 */
		prompt(list[i], buf);
		/*
		 * read the response
		 */
		if (fgets(addrs[i], BUFSIZ, stdin) == NULL){
			PRINTF("Finger information unchanged.\n");
			exit(0);
		}
		/*
		 * kill the newline if any
		 */
		if (*(s = &addrs[i][strlen(addrs[i])-1]) == '\n')
			*s = '\0';
		/*
		 * if return, default stays
		 */
		if (addrs[i][0] == '\0'){
			(void) strcpy(addrs[i], buf);
			continue;
		}
		/*
		 * if 'none', zap it
		 */
		if (strcmp(buf, "none") == 0)
			addrs[i][0] = '\0';
		/*
		 * otherwise it's okay as it stands
		 */
	}

	/*
	 * done -- update the record
	 */
	fixup(prfmt);
	SPRINTF(buf, prfmt, addr1, addr2, addr3, addr4, addr5, addr6,
							addr7, addr8, addr9);
	p->pw_gecos = buf;
	(void) update_pwd(p);

	/*
	 * bye
	 */
	exit(0);
}

/*
 * change a prompt by user request
 */
getprompt(s)
char *s;			/* line with request */
{
	char buf[BUFSIZ];		/* buffer for new prompt */
	register char *b;		/* used to walk buffer */
	register int i;			/* counter in a for loop */
	char k;				/* key character */

	/*
	 * skip leading spaces to get to key character
	 */
	while(isspace(*s))
		s++;
	if (!*s)
		return;
	/*
	 * grab key character
	 */
	k = *s++;
	/*
	 * eat spaces to go to prompt
	 */
	while(isspace(*s))
		s++;
	/*
	 * at prompt; stuff it away
	 */
	if (*s == '"'){
		for (b = buf; *s && *s != '"'; *b++ = *s++);
		if (!*s){
			LOG1(LG_SYNTAX,
				"missing \" in PROMPT specification on line %d",
								linect);
			return;
		}
	}
	else{
		LOG1(LG_SYNTAX,
		    "missing \" in PROMPT specification on line %d", linect);
		return;
	}
	/*
	 * update the prompt
	 */
	for(i = 0; iv[i].name != '\0'; i++)
		if (k == iv[i].name){
			iv[i].prompt = strsave(buf);
			return;
		}
}

/*
 * prompt for update
 */
prompt(c, def)
char c;			/* what to ask for */
char def[];		/* default value */
{
	register struct intvar *ip;	/* points to internal variable */

	/*
	 * see if the prompt request can be met
	 */
	ip = findiv(c);

	/*
	 * is not known, shrug;
	 * if known, prompt
	 */
	def[0] = '\0';
	if (ip->name == '\0')
		PRINTF("Unknown field {best bet is to type 'none'} []: ");
	else if (ip->string != CH_NULL){
		PRINTF(ip->prompt, ip->string);
		(void) strcpy(def, ip->string);
	}
	else
		PRINTF(ip->prompt, "\0");
	(void) fflush(stdout);
}

/*
 * this just says what should be in the GECOS field
 */
forcegecos(format, prfmt, list)
char *format;			/* what to analyze */
char *prfmt;			/* printf format string */
char *list;			/* how to parse it */
{
	register char *f, *fb;	/* used to collect the format string */
	register int i;		/* counter in a for loop */
	register int n;		/* number of strings read in */

	/*
	 * now read in the format string
	 */
	for(f = format; *f && *f != '"'; f++);
	/*
	 * none present -- skip line
	 */
	if (!*f)
		return(-1);
	/*
	 * skip initial quote, stuff string
	 */
	n = 0;
	fb = prfmt;
	for(f++; *f && *f != '"'; *fb++ = *f++)
		if (*f == '%'){
			if (f[1] == '%')
				*fb++ = *f++;
			else
				n++;
		}
	*fb = '\0';
	/*
	 * no closing quote -- ignore line
	 */
	if (!*f){
		LOG1(LG_SYNTAX,
			"missing \" in FORCEGECOS specification on line %d", linect);
		return(-1);
	}
	/*
	 * skip closing quote
	 */
	f++;
	fb = f;
	i = 0;
	while(*fb && (findiv(*fb) != IV_NULL || isspace(*fb))){
		if (!isspace(*fb))
			list[i++] = *fb;
		fb++;
	}
	if (*fb && findiv(*fb) == IV_NULL){
		LOG2(LG_SYNTAX,
			"bad FORCEGECOS specification at line %d (\"%s\")",
								linect, fb);
		return(-1);
	}
	else if (i != n){
		LOG1(LG_SYNTAX,
			"wrong number of escapes in FORCEGECOS specification on line %d",
				linect);
		return(-1);
	}

	return(0);
}

/*
 * this changes a scanf format into a printf format
 */
fixup(buf)
char buf[];		/* format string */
{
	register char *b, *p;		/* used to copy string */

	/*
	 * ignore any %*<num><c>
	 * change any %[...] to %s
	 */
	for(b = p = buf; *b; ){
		if (*b != '%'){		/* not escape, copy */
			*p++ = *b++;
			continue;
		}
		if (*++b == '*'){	/* ignore this */
			b++;
			while(isdigit(*b))
				b++;
			b++;
			continue;
		}
		else if (*b == '['){	/* change this to %s */
			while(*b && *b != ']')
				b++;
			if (*b == ']')
				b++;
			*p++ = '%';
			*p++ = 's';
			continue;
		}
		else{			/* copy this */
			*p++ = '%';
			while(isdigit(*b))
				*p++ = *b++;
			*p++ = *b++;
		}
	}

	/*
	 * close off new string
	 */
	*p++ = '\0';
}

#endif
