#include "sys.h"
.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)passwd.1	1.0 (Dartmouth) 9/29/87
.\"
.TH PASSWD 1 "September 29, 1987"
.UC 4
.SH NAME
#ifdef CHFN
chfn,
#endif
#ifdef GETUSERSHELL
chsh,
#endif
passwd \- change password file information
.SH SYNOPSIS
.B passwd
[
.BI \-F " file"
]
[
.BI \-t " file"
]
#ifdef CHFN
[
.B \-f
]
#endif
#ifdef GETUSERSHELL
[
.B \-s
]
#endif
[ name ]
#ifdef CHFN
.br
.B chfn
#endif
#ifdef GETUSERSHELL
.br
.B chsh
#endif
.SH DESCRIPTION
This command changes (or installs)
#ifdef CHFN
#ifdef GETUSERSHELL
the password, the GECOS information (using the
.B \-f
option),
or the login shell (using the
.B \-s
option)
#else
the password or the GECOS information (using the
.B \-f
option)
#endif
#else
#ifdef GETUSERSHELL
the password or the login shell (using the
.B \-s
option)
#else
the password
#endif
#endif
associated with the user
.I name
(your own name by default).
.PP
When altering a password,
the program prompts for the current password and then for the new one.
The caller must supply both.
The new password must be typed twice to forestall mistakes.
.PP
New passwords are tested to ensure that they are not easy to guess.
The specific tests used vary from site to site.
Unlike the standard password command,
these rules may be abrogated only by changing the tests.
The tests are contained in the file
.IR %%PWTEST%% ;
the superuser may specify another test file with the
.B \-t
option.
This is intended for debugging a new test file.
.PP
Only the owner of the name or the super-user may change a password;
the owner must prove he knows the old password.
#ifdef GETUSERSHELL
.PP
When altering a login shell,
.I passwd
displays the current login shell and then prompts
for the new one.
The new login shell must be one of the approved shells
listed in
.I /etc/shells
unless you are the super-user.
If
.I /etc/shells
does not exist, the only shells that may be specified are
.I /bin/sh
and
.IR /bin/csh .
.PP
The super-user may change anyone's login shell;
normal users may only change their own login shell.
#endif
#ifdef CHFN
.PP
When altering the GECOS information field,
.I passwd
displays the current information, broken into fields,
as interpreted by the
.IR finger (1)
program, among others, and prompts for new values.
These fields vary from site to site.
Included in each prompt is a default value,
which is enclosed between brackets.
The default value is accepted simply by typing a carriage
return.  To enter a blank field, the word ``none'' may
be typed.  Below is a sample run for a format that specifies full name,
office number,
and telephone number:
.IP
.B "Name [Johnathan D. Doe]:"
.br
.B "Office [1600 Brilliant]:"
212 Silly
.br
.B "Phone [(123)555-1212x2307]:"
none
.sp
.PP
.I Passwd
allows phone numbers to be entered with or without hyphens.
It is a good idea to run
.I finger
after changing the GECOS information
to make sure everything is setup properly.
.PP
The super-user may change anyone's GECOS information; normal
users may only change their own.
#endif
.PP
All changes are made to the file
.I %%PWFILE%%
unless an alternate password file is specified with the
.B \-F
option.
.SH FILES
%%PWFILE%%	The file containing all of this information
.br
%%PWTEST%%	The set of tests for new passwords
#ifdef GETUSERSHELL
.br
/etc/shells	The list of approved shells
#endif
.SH "SEE ALSO"
login(1), finger(1), passwd(5), crypt(3)
.br
Robert Morris and Ken Thompson,
.I UNIX password security
