/*
 * various utilities, like stream readers, error handlers, etc.
 */
#include "passwd.h"

/*
 * convert an integer to a string representing that number
 */
char *tonum(n)
int n;				/* number to be ACSII-ized */
{
	char buf[BUFSIZ];		/* temporary buffer */

	/*
	 * ASCII-ize the number
	 */
	SPRINTF(buf, "%d", n);

	/*
	 * stuff it somewhere safe and return that location
	 */
	return(strsave(buf));
}

/*
 * save a string in an allocated location
 */
static char *nulstr = "";	/* NULL string used in emergencies */
char *strsave(s)
char *s;			/* string to be saved */
{
	register char *p;		/* points to new chunk of memory */

	/*
	 * if given nothing, return empty string
	 */
	if (s == CH_NULL)
		return(nulstr);

	/*
	 * do the allocation;
	 * if a problem, return the EMPTY string
	 */
	if ((p = malloc((unsigned) (strlen(s)+1))) == CH_NULL){
		if (errno < sys_nerr){
			LOG1(LG_SYSTEM, "strsave: %s", sys_errlist[errno]);
		}
		else
			LOG1(LG_SYSTEM, "strsave: unknown error #%d", errno);
		perror("strsave");
		return(nulstr);
	}

	/*
	 * copy the string to be saved
	 * to the newly-allocated memory
	 * and return the location of that memory
	 */
	(void) strcpy(p, s);
	return(p);
}

/*
 * like atoi() but advances pointer
 */
int matoi(str)
char **str;		/* string to be evaluated */
{
	register int n;			/* number to be returned */

	/*
	 * loop and shrink letters
	 */
	n = 0;
	if (isdigit(**str))
		while(isdigit(**str))
			n = n * 10 + *(*str)++ - '0';
	/*
	 * return the number
	 */
	return(n);
}

/*
 * error exit routine
 */
pwexit(ermsg)
char *ermsg;				/* error message */
{
	sigoff();
	FPRINTF(stderr, "%s: %s\n", progname, ermsg);
	exit(1);
}

/*
 * for the string formatting
 */
char *sfmt(ptr, sgn, n1, n2, num, string, length)
register char *ptr;			/* used to advance a pointer */
int sgn;				/* sign (1 if "-") */
register int n1;			/* starting point */
register int n2;			/* ending point */
int num;				/* how to format the string */
char *string;				/* the quantity to be interpolated */
char *length;				/* its length */
{
	register int slen;		/* pctstring length */

	/*
	 * if the string is empty, skip it
	 */
	if (string == CH_NULL)
		return(ptr);

	/*
	 * just a giant switch statement
	 */
	switch(num){
	case F_NUMBER:			/* length */
		/*
		 * just copy the sucker
		 */
		for(n1 = 0; length[n1]; n1++)
			*ptr++ = length[n1];
		break;
	case F_LOWER:			/* lower case */
		if (sgn){
			/*
			 * string is shorter than beginning mark
			 */
			if ((slen = strlen(string)) <= n1)
				return(ptr);
			if (slen <= n2)
				n2 = slen - 1;
			/*
			 * just copy the indicated parts of the string, reversed
			 */
			for( ; n2 >= n1; n2--)
				*ptr++ = lowcase(string[n2]);
		}
		else{
			/*
			 * string is shorter than beginning mark
			 */
			if ((slen = strlen(string)) <= n1)
				return(ptr);
			/*
			 * just copy the indicated parts of the string
			 */
			for( ; n1 <= n2 && string[n1]; n1++)
				*ptr++ = lowcase(string[n1]);
		}
		break;
	case F_FIRST:			/* first upper case */
		if (sgn){
			/*
			 * string is shorter than beginning mark
			 */
			if ((slen = strlen(string)) <= n1)
				return(ptr);
			if (slen <= n2)
				n2 = slen - 1;
			/*
			 * just copy the indicated parts of the string, reversed
			 */
			for( ; n2 >= n1; n2--)
				if (n2 == 0)
					*ptr++ = upcase(string[n2]);
				else
					*ptr++ = string[n2];
		}
		else{
			/*
			 * string is shorter than beginning mark
			 */
			if ((slen = strlen(string)) <= n1)
				return(ptr);
			/*
			 * just copy the indicated parts of the string
			 */
			for( ; n1 <= n2 && string[n1]; n1++)
				if (n1 == 0)
					*ptr++ = upcase(string[n1]);
				else
					*ptr++ = string[n1];
		}
		break;
	case F_UPPER:			/* upper case */
		if (sgn){
			/*
			 * string is shorter than beginning mark
			 */
			if ((slen = strlen(string)) <= n1)
				return(ptr);
			if (slen <= n2)
				n2 = slen - 1;
			/*
			 * just copy the indicated parts of the string, reversed
			 */
			for( ; n2 >= n1; n2--)
				*ptr++ = upcase(string[n2]);
		}
		else{
			/*
			 * string is shorter than beginning mark
			 */
			if ((slen = strlen(string)) <= n1)
				return(ptr);
			/*
			 * just copy the indicated parts of the string
			 */
			for( ; n1 <= n2 && string[n1]; n1++)
				*ptr++ = upcase(string[n1]);
		}
		break;
	default:			/* as is */
		if (sgn){
			/*
			 * string is shorter than beginning mark
			 */
			if ((slen = strlen(string)) <= n1)
				return(ptr);
			if (slen <= n2)
				n2 = slen - 1;
			/*
			 * just copy the indicated parts of the string, reversed
			 */
			while(n2 >= n1)
				*ptr++ = string[n2--];
		}
		else{
			/*
			 * string is shorter than beginning mark
			 */
			if ((slen = strlen(string)) <= n1)
				return(ptr);
			/*
			 * just copy the indicated parts of the string
			 */
			while(n1 <= n2 && string[n1])
				*ptr++ = string[n1++];
		}
		break;
	}
	/*
	 * return the new string position
	 */
	return(ptr);
}

/*
 * for the number formatting
 */
char *nfmt(ptr, sgn, string, length)
register char *ptr;			/* used to advance a pointer */
int sgn;				/* sign (1 if "-") */
char *string;				/* the quantity to be interpolated */
char *length;				/* its length */
{
	register char *ob;	/* used to copy string */

	/*
	 * just a giant switch statement
	 */
	if (!sgn){
		/*
		 * if the string is empty, skip it
		 */
		if ((ob = string) == CH_NULL)
			return(ptr);
		/*
		 * just copy the sucker
		 */
		while(*ob)
			*ptr++ = *ob++;
	}
	else{
		/*
		 * if the string is empty, skip it
		 */
		if ((ob = length) == CH_NULL)
			return(ptr);
		/*
		 * just copy the sucker
		 */
		while(*ob)
			*ptr++ = *ob++;
	}
	/*
	 * return the new string position
	 */
	return(ptr);
}

/*
 * read a C string
 * returns position to be read next (just after closing quote)
 */
char *getcstring(from, to, quo)
char *from;			/* where to begin */
char *to;			/* copy to here */
char quo;			/* terminal quote mark */
{
	register int n;		/* number from \nnn escape */
	register int i;		/* counter in a for loop */

	/*
	 * go until string ends or you hit a NUL
	 */
	while(*from && *from != quo){
		/*
		 * not an escape -- take anything
		 */
		if (*from++ != '\\')
			*to++ = from[-1];
		/*
		 * escapes
		 * -------
		 * \ddd -- octal bit pattern
		 */
		else if (isdigit(*from)){
			n = 0;
			for(i = 0; i < 3 && isdigit(*from); i++)
				n = n * 10 + *from++ - '0';
			*to++ = (char) (n&0xff);
		}
		/*
		 * \c --- standard C escape
		 */
		else switch(*++from){
		case 'n':	*to++ = '\n';		break;
		case 't':	*to++ = '\t';		break;
		case 'b':	*to++ = '\b';		break;
		case 'r':	*to++ = '\r';		break;
		case 'f':	*to++ = '\f';		break;
		case '\\':	*to++ = '\\';		break;
		default:	*to++ = from[-1];	break;
		}
	}
	*to = '\0';
	return(from);
}

/*
 * gets the host name, if possible
 */
findhost(name, siznam)
char *name;			/* where to put the name */
int siznam;			/* number of bytes available for name */
{
#ifdef GETHOST
	return(GETHOST(name, siznam));
#else
#ifdef HOSTNAME
	(void) strncpy(name, HOSTNAME, siznam);
#else
	(void) strncpy(name, "* no host name known *", siznam);
#endif
	return(0);
#endif
}
	
/*
 * gets the domain name, if possible
 */
finddomain(name, siznam)
char *name;			/* where to put the name */
int siznam;			/* number of bytes available for name */
{
	register char *p;	/* used to get domain part of host name */
	char buf[BUFSIZ];	/* buffer for name */

	if (findhost(buf, BUFSIZ) < 0){
#ifdef GETDOMAIN
		return(GETDOMAIN(name, siznam));
#else
		return(-1);
#endif
	}
	/*
	 * everything after first "." is it
	 */
	if ((p = index(buf, '.')) == CH_NULL || *++p == '\0')
		return(-1);
	/*
	 * copy it in
	 */
	(void) strncpy(name, &p[1], siznam);
	return(0);
}
