/*
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Contributed by Paul Pomes, University of Illinois Computing Services Office.
 *
 *	@(#)def.h	1.1	2/17/91
 */

/*
 * ANSI C function declarators
 */

#ifndef lint
# ifdef _DEFINE
static char def_h_sccsid[] = "@(#)def.h	1.1 (Berkeley) 2/17/91";
static char  def_h_rcsid[] = "@(#)$Id: def.h,v 1.26 1992/08/21 05:14:29 paul Exp $";
# endif /* _DEFINE */
#endif /* !lint */

/* List of machine types that don't do type promotion in prototypes */
#if defined(M_XENIX) || (defined(apollo) && !defined(_TIME_T))
# define	CC_WONT_PROMOTE
#endif /* M_XENIX || (apollo && !_TIME_T) */

/* alias.c */
void alias __P((ADDRESS *, ADDRESS **));
char * aliaslookup __P((char *));
#ifdef HESIOD
char * hes_aliaslookup __P((const char *));
#endif /* HESIOD */
void initaliases __P((bool));
void forward __P((ADDRESS *, ADDRESS **));

/* arpadate.c */
char * arpadate __P((char *));
char * arpatounix __P((char *, ENVELOPE *));

/* clock.c */
EVENT * setevent __P((TIME_TYPE, void (*)(), int));
void clrevent __P((EVENT *));
void Xsleep __P((unsigned int));

/* collect.c */
void collect __P((bool));

/* conf.c */
void setdefaults();
void setdefuser();
int getruid();
int getrgid();
char * username();
char * ttypath();
bool checkcompat __P((ADDRESS *));
void holdsigs();
void rlsesigs();
int getla();
bool shouldqueue __P((long));
void setproctitle __P((const char *, ...));
SIG_TYPE reapchild __P((int));

/* convtime.c */
TIME_TYPE convtime __P((const char *));
char * pintvl __P((TIME_TYPE, bool));

/* daemon.c */
void getrequests();
void clrdaemon();
#ifdef CC_WONT_PROMOTE
int makeconnection __P((const char *, u_short, FILE **, FILE **));
#else /* !CC_WONT_PROMOTE */
int makeconnection __P((const char *, int, FILE **, FILE **)); /* u_short -> int */
#endif /* CC_WONT_PROMOTE */
char ** myhostname __P((char [], int));
bool maphostname __P((char *, bool));
#ifdef CC_WONT_PROMOTE
bool mapinit __P((char));
char * mapkey __P((char, char *, int, const char *));
#else /* !CC_WONT_PROMOTE */
bool mapinit __P((int));					/* char -> int */
char * mapkey __P((int, char *, int, const char *));	/* char -> int */
#endif /* CC_WONT_PROMOTE */

/* deliver.c */
int deliver __P((ENVELOPE *, ADDRESS *));
void markfailure __P((ENVELOPE *, ADDRESS *, int));
int dofork();
int endmailer __P((int, const char *));
int openmailer __P((MAILER *, char **, ADDRESS *, bool, FILE **, FILE **));
void giveresponse __P((int, MAILER *, ENVELOPE *));
void logdelivery __P((MAILER *, const char *));
void putfromline __P((FILE *, MAILER *));
void putbody __P((FILE *, MAILER *, ENVELOPE *));
#ifdef CC_WONT_PROMOTE
void sendall __P((ENVELOPE *, char));
#else /* !CC_WONT_PROMOTE */
void sendall __P((ENVELOPE *, int));			/* char -> int */
#endif /* CC_WONT_PROMOTE */

/* domain.c */
int getmxrr __P((const char *, char **, int *));
bool getcanonname __P((char *, int));

/* envelope.c */
ENVELOPE * newenvelope __P((ENVELOPE *));
void dropenvelope __P((ENVELOPE *));
void clearenvelope __P((ENVELOPE *, bool));
void initsys();
void settime();
void openxscript __P((ENVELOPE *));
void setsender __P((char *));

/* err.c */
/*
** Prevents redefinition of printf by charset/conv.c -Dsyserr=printf .
** AIX V3 has a typedef for syserr in sysinfo.h .
*/
#if !defined(syserr) && !defined(_AIX) && !defined(AIX)
void syserr __P((const char *, ...));
#endif /* !syserr && !_AIX && !AIX */
void usrerr __P((const char *, ...));
void message __P((const char *, const char *, ...));
void nmessage __P((const char *, const char *, ...));
char * errstring __P((int));

/* getloadavg.c */
int getloadavg __P((caddr_t));

/* headers.c */
int chompheader __P((char *, bool));
void addheader __P((char *, const char *, ENVELOPE *));
char * hvalue __P((const char *));
HDR * findheader __P((const char *, ENVELOPE *));
bool isheader __P((const char *));
void eatheader __P((ENVELOPE *, FILE *));
char * crackaddr __P((char *));
void putheader __P((FILE *, MAILER *, ENVELOPE *));
void commaize __P((HDR *, char *, FILE *, bool, MAILER *));
#ifdef CC_WONT_PROMOTE
char * finddelim __P((char *, char));
#else /* !CC_WONT_PROMOTE */
char * finddelim __P((char *, int));
#endif /* CC_WONT_PROMOTE */

/* macro.c */
void expand __P((const char *, char *, const char *, ENVELOPE *));
#ifdef CC_WONT_PROMOTE
void define __P((char, char *, ENVELOPE *));
char * macvalue __P((char, ENVELOPE *));
#else /* !CC_WONT_PROMOTE */
void define __P((int, char *, ENVELOPE *));		/* char -> int */
char * macvalue __P((int, ENVELOPE *));			/* char -> int */
#endif /* CC_WONT_PROMOTE */

/* main.c */
void finis();
void disconnect __P((bool));

/* parseaddr.c */
#ifdef CC_WONT_PROMOTE
ADDRESS * parseaddr __P((char *, ADDRESS *, int, char));
char ** prescan __P((char *, char, char []));
#else /* !CC_WONT_PROMOTE */
ADDRESS * parseaddr __P((char *, ADDRESS *, int, int));	/* char -> int */
char ** prescan __P((char *, int, char []));		/* char -> int */
#endif /* CC_WONT_PROMOTE */
void loweraddr __P((ADDRESS *));
bool invalidaddr __P((const char *));
void rewrite __P((char **, int));
void cataddr __P((char **, char *, int));
bool sameaddr __P((ADDRESS *, ADDRESS *));
void printaddr __P((ADDRESS *, bool));
char * remotename __P((char *, MAILER *, bool, bool, bool));

/* queue.c */
FILE * queueup __P((ENVELOPE *, bool, bool, FILE *));
void runqueue __P((int));
void printqueue();
#ifdef CC_WONT_PROMOTE
char * queuename __P((ENVELOPE *, char));
#else /* !CC_WONT_PROMOTE */
char * queuename __P((ENVELOPE *, int));			/* char -> int */
#endif /* CC_WONT_PROMOTE */
void unlockqueue __P((ENVELOPE *));
void setctladdr __P((ADDRESS *));

/* readcf.c */
void readcf __P((char *));
void printrules();
#ifdef CC_WONT_PROMOTE
void setoption __P((char, const char *, bool, bool));
#else /* !CC_WONT_PROMOTE */
void setoption __P((int, const char *, bool, bool));	/* char -> int */
#endif /* CC_WONT_PROMOTE */
void setclass __P((int, const char *));

/* recipient.c */
void sendtolist __P((const char *, ADDRESS *, ADDRESS **));
ADDRESS * recipient __P((ADDRESS *, ADDRESS **));
void include __P((const char *, const char *, ADDRESS *, ADDRESS **));
void sendtoargv __P((char **));
ADDRESS * getctladdr __P((ADDRESS *));

/* savemail.c */
void savemail __P((ENVELOPE *));
int returntosender __P((const char *, ADDRESS *, bool));

/* srvrsmtp.c */
void smtp __P((bool));

/* stab.c */
STAB * stab __P((const char *, int, int));

/* stats.c */
void markstats __P((ENVELOPE *, ADDRESS *));
void poststats __P((char *));

/* sysexits.c */
char * statstring __P((int));

/* trace.c */
void tTsetup __P((u_char *, int, const char *));
void tTflag __P((const char *));

/* usersmtp.c */
#ifdef MAIL11V3
int smtpinit __P((MAILER *, char **, ENVELOPE *));
#else /* ! MAIL11V3 */
int smtpinit __P((MAILER *, char **));
#endif /* MAIL11V3 */
int smtprcpt __P((ADDRESS *, MAILER *));
int smtpdata __P((MAILER *, ENVELOPE *));
void smtpquit __P((MAILER *));
int smtpstat __P((MAILER *));

/* util.c */
void stripquotes __P((char *, bool));
int qstrlen __P((const char *));
char * capitalize __P((const char *));
#ifdef __STDC__
void * xalloc __P((int));
#else /* !__STDC__ */
char * xalloc __P((int));
#endif /* __STDC__ */
char ** copyplist __P((char **, bool));
void printav __P((char **));
#ifdef CC_WONT_PROMOTE
char lower __P((char));
#else /* !CC_WONT_PROMOTE */
char lower __P((int));					/* char -> int */
#endif /* CC_WONT_PROMOTE */
void xputs __P((const char *));
void makelower __P((char *));
void buildfname __P((const char *, const char *, char *));
bool safefile __P((char *, int, int));
void fixcrlf __P((char *, bool));
FILE * dfopen __P((const char *, const char *));
void putline __P((char *, FILE *, MAILER *));
void xunlink __P((char *));
char * sfgets __P((char *, int, FILE *));
void sfgetsinit();
void sfgetsfini();
void readtimeout __P((TIME_TYPE));
char * fgetfolded __P((char *, int, FILE *));
TIME_TYPE curtime();
bool atobool __P((const char *));
int atooct __P((const char *));
int waitfor __P((int));
bool bitintersect __P((BITMAP, BITMAP));
bool bitzerop __P((BITMAP));
void printcav __P((char **));
void WritePid();

/* strcnv.c */
#ifdef BIT8
CHAR8U * strcnv __P((CHARSET *, CHARSET *, CHAR8U *, CHAR8U *));
CHAR8U * strncnv __P((CHARSET *, CHARSET *, CHAR8U *, CHAR8U *, int));
# ifdef CC_WONT_PROMOTE
CHARSET * getchset __P((char *, INT16S));
# else /* !CC_WONT_PROMOTE */
CHARSET * getchset __P((char *, int));
# endif /* CC_WONT_PROMOTE */
#endif /* BIT8 */

/* version.c */

/* random ones */

char * getenv __P((const char *));
FILE * fdopen __P((int, const char *));
FILE * popen __P((const char *, const char *));
TIME_TYPE time __P((TIME_TYPE *));
