/* $NetBSD: linux_sysent.c,v 1.16 2025/11/10 15:41:56 christos Exp $ */

/*
 * System call switch table.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.17 2025/11/10 15:41:37 christos Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: linux_sysent.c,v 1.16 2025/11/10 15:41:56 christos Exp $");

#if defined(_KERNEL_OPT)
#include "opt_sysv.h"
#include "opt_compat_43.h"
#include "opt_compat_netbsd.h"
#endif
#include <sys/param.h>
#include <sys/poll.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/mount.h>
#include <sys/syscallargs.h>
#include <sys/time.h>
#include <compat/sys/time.h>
#include <compat/linux/common/linux_types.h>
#include <compat/linux/common/linux_ipc.h>
#include <compat/linux/common/linux_machdep.h>
#include <compat/linux/common/linux_misc.h>
#include <compat/linux/common/linux_mmap.h>
#include <compat/linux/common/linux_msg.h>
#include <compat/linux/common/linux_sched.h>
#include <compat/linux/common/linux_sem.h>
#include <compat/linux/common/linux_shm.h>
#include <compat/linux/common/linux_siginfo.h>
#include <compat/linux/common/linux_signal.h>
#include <compat/linux/common/linux_mqueue.h>
#include <compat/linux/linux_syscallargs.h>

#define	s(type)	sizeof(type)
#define	n(type)	(sizeof(type)/sizeof (register_t))
#define	ns(type)	.sy_narg = n(type), .sy_argsize = s(type)

struct sysent linux_sysent[] = {
	{
		.sy_call = linux_sys_nosys,
	},		/* 0 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 1 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 2 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 3 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 4 = filler */
	{
		ns(struct linux_sys_setxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setxattr
	},		/* 5 = setxattr */
	{
		ns(struct linux_sys_lsetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lsetxattr
	},		/* 6 = lsetxattr */
	{
		ns(struct linux_sys_fsetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fsetxattr
	},		/* 7 = fsetxattr */
	{
		ns(struct linux_sys_getxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getxattr
	},		/* 8 = getxattr */
	{
		ns(struct linux_sys_lgetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lgetxattr
	},		/* 9 = lgetxattr */
	{
		ns(struct linux_sys_fgetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fgetxattr
	},		/* 10 = fgetxattr */
	{
		ns(struct linux_sys_listxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_listxattr
	},		/* 11 = listxattr */
	{
		ns(struct linux_sys_llistxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_llistxattr
	},		/* 12 = llistxattr */
	{
		ns(struct linux_sys_flistxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_flistxattr
	},		/* 13 = flistxattr */
	{
		ns(struct linux_sys_removexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_removexattr
	},		/* 14 = removexattr */
	{
		ns(struct linux_sys_lremovexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lremovexattr
	},		/* 15 = lremovexattr */
	{
		ns(struct linux_sys_fremovexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fremovexattr
	},		/* 16 = fremovexattr */
	{
		ns(struct sys___getcwd_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___getcwd
	},		/* 17 = __getcwd */
	{
		.sy_call = linux_sys_nosys,
	},		/* 18 = filler */
	{
		ns(struct linux_sys_eventfd2_args),
		.sy_call = (sy_call_t *)linux_sys_eventfd2
	},		/* 19 = eventfd2 */
	{
		ns(struct linux_sys_epoll_create1_args),
		.sy_call = (sy_call_t *)linux_sys_epoll_create1
	},		/* 20 = epoll_create1 */
	{
		ns(struct linux_sys_epoll_ctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_epoll_ctl
	},		/* 21 = epoll_ctl */
	{
		ns(struct linux_sys_epoll_pwait_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_epoll_pwait
	},		/* 22 = epoll_pwait */
	{
		ns(struct sys_dup_args),
		.sy_call = (sy_call_t *)sys_dup
	},		/* 23 = dup */
	{
		ns(struct linux_sys_dup3_args),
		.sy_call = (sy_call_t *)linux_sys_dup3
	},		/* 24 = dup3 */
	{
		ns(struct linux_sys_fcntl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fcntl
	},		/* 25 = fcntl */
	{
		ns(struct linux_sys_inotify_init1_args),
		.sy_call = (sy_call_t *)linux_sys_inotify_init1
	},		/* 26 = inotify_init1 */
	{
		ns(struct linux_sys_inotify_add_watch_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_inotify_add_watch
	},		/* 27 = inotify_add_watch */
	{
		ns(struct linux_sys_inotify_rm_watch_args),
		.sy_call = (sy_call_t *)linux_sys_inotify_rm_watch
	},		/* 28 = inotify_rm_watch */
	{
		ns(struct linux_sys_ioctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ioctl
	},		/* 29 = ioctl */
	{
		.sy_call = linux_sys_nosys,
	},		/* 30 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 31 = filler */
	{
		ns(struct sys_flock_args),
		.sy_call = (sy_call_t *)sys_flock
	},		/* 32 = flock */
	{
		ns(struct linux_sys_mknodat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mknodat
	},		/* 33 = mknodat */
	{
		ns(struct sys_mkdirat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mkdirat
	},		/* 34 = mkdirat */
	{
		ns(struct linux_sys_unlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_unlinkat
	},		/* 35 = unlinkat */
	{
		ns(struct sys_symlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_symlinkat
	},		/* 36 = symlinkat */
	{
		ns(struct linux_sys_linkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_linkat
	},		/* 37 = linkat */
	{
		ns(struct sys_renameat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_renameat
	},		/* 38 = renameat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 39 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 40 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 41 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 42 = filler */
	{
		ns(struct linux_sys_statfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_statfs
	},		/* 43 = statfs */
	{
		ns(struct linux_sys_fstatfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstatfs
	},		/* 44 = fstatfs */
	{
		ns(struct linux_sys_truncate64_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_truncate64
	},		/* 45 = truncate64 */
	{
		ns(struct linux_sys_ftruncate64_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64,
		.sy_call = (sy_call_t *)linux_sys_ftruncate64
	},		/* 46 = ftruncate64 */
	{
		ns(struct linux_sys_fallocate_args),
		.sy_flags = SYCALL_NARGS64_VAL(2) | SYCALL_ARG3_64 | SYCALL_ARG2_64,
		.sy_call = (sy_call_t *)linux_sys_fallocate
	},		/* 47 = fallocate */
	{
		ns(struct linux_sys_faccessat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_faccessat
	},		/* 48 = faccessat */
	{
		ns(struct sys_chdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chdir
	},		/* 49 = chdir */
	{
		ns(struct sys_fchdir_args),
		.sy_call = (sy_call_t *)sys_fchdir
	},		/* 50 = fchdir */
	{
		ns(struct sys_chroot_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chroot
	},		/* 51 = chroot */
	{
		ns(struct sys_fchmod_args),
		.sy_call = (sy_call_t *)sys_fchmod
	},		/* 52 = fchmod */
	{
		ns(struct linux_sys_fchmodat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fchmodat
	},		/* 53 = fchmodat */
	{
		ns(struct linux_sys_fchownat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fchownat
	},		/* 54 = fchownat */
	{
		ns(struct sys___posix_fchown_args),
		.sy_call = (sy_call_t *)sys___posix_fchown
	},		/* 55 = __posix_fchown */
	{
		ns(struct linux_sys_openat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_openat
	},		/* 56 = openat */
	{
		ns(struct sys_close_args),
		.sy_call = (sy_call_t *)sys_close
	},		/* 57 = close */
	{
		.sy_call = linux_sys_nosys,
	},		/* 58 = filler */
	{
		ns(struct linux_sys_pipe2_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pipe2
	},		/* 59 = pipe2 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 60 = filler */
	{
		ns(struct linux_sys_getdents64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getdents64
	},		/* 61 = getdents64 */
	{
		ns(struct compat_43_sys_lseek_args),
		.sy_call = (sy_call_t *)compat_43_sys_lseek
	},		/* 62 = lseek */
	{
		ns(struct sys_read_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_read
	},		/* 63 = read */
	{
		ns(struct sys_write_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_write
	},		/* 64 = write */
	{
		ns(struct sys_readv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readv
	},		/* 65 = readv */
	{
		ns(struct sys_writev_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_writev
	},		/* 66 = writev */
	{
		ns(struct linux_sys_pread_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG3_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pread
	},		/* 67 = pread */
	{
		ns(struct linux_sys_pwrite_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG3_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pwrite
	},		/* 68 = pwrite */
	{
		ns(struct linux_sys_preadv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_preadv
	},		/* 69 = preadv */
	{
		ns(struct linux_sys_pwritev_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pwritev
	},		/* 70 = pwritev */
	{
		.sy_call = linux_sys_nosys,
	},		/* 71 = filler */
	{
		ns(struct linux_sys_pselect6_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pselect6
	},		/* 72 = pselect6 */
	{
		ns(struct linux_sys_ppoll_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ppoll
	},		/* 73 = ppoll */
	{
		.sy_call = linux_sys_nosys,
	},		/* 74 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 75 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 76 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 77 = filler */
	{
		ns(struct sys_readlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readlinkat
	},		/* 78 = readlinkat */
	{
		ns(struct linux_sys_fstatat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstatat64
	},		/* 79 = fstatat64 */
	{
		ns(struct linux_sys_fstat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstat64
	},		/* 80 = fstat64 */
	{
		.sy_call = (sy_call_t *)sys_sync
	},		/* 81 = sync */
	{
		ns(struct sys_fsync_args),
		.sy_call = (sy_call_t *)sys_fsync
	},		/* 82 = fsync */
	{
		ns(struct linux_sys_fdatasync_args),
		.sy_call = (sy_call_t *)linux_sys_fdatasync
	},		/* 83 = fdatasync */
	{
		ns(struct linux_sys_sync_file_range_args),
		.sy_flags = SYCALL_NARGS64_VAL(2) | SYCALL_ARG2_64 | SYCALL_ARG1_64,
		.sy_call = (sy_call_t *)linux_sys_sync_file_range
	},		/* 84 = sync_file_range */
	{
		ns(struct linux_sys_timerfd_create_args),
		.sy_call = (sy_call_t *)linux_sys_timerfd_create
	},		/* 85 = timerfd_create */
	{
		ns(struct linux_sys_timerfd_settime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_timerfd_settime
	},		/* 86 = timerfd_settime */
	{
		ns(struct linux_sys_timerfd_gettime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_timerfd_gettime
	},		/* 87 = timerfd_gettime */
	{
		ns(struct linux_sys_utimensat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_utimensat
	},		/* 88 = utimensat */
	{
		ns(struct sys_acct_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_acct
	},		/* 89 = acct */
	{
		.sy_call = linux_sys_nosys,
	},		/* 90 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 91 = filler */
	{
		ns(struct linux_sys_personality_args),
		.sy_call = (sy_call_t *)linux_sys_personality
	},		/* 92 = personality */
	{
		ns(struct linux_sys_exit_args),
		.sy_call = (sy_call_t *)linux_sys_exit
	},		/* 93 = exit */
	{
		ns(struct linux_sys_exit_group_args),
		.sy_call = (sy_call_t *)linux_sys_exit_group
	},		/* 94 = exit_group */
	{
		ns(struct linux_sys_waitid_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_waitid
	},		/* 95 = waitid */
	{
		ns(struct linux_sys_set_tid_address_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_set_tid_address
	},		/* 96 = set_tid_address */
	{
		.sy_call = linux_sys_nosys,
	},		/* 97 = filler */
	{
		ns(struct linux_sys_futex_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_futex
	},		/* 98 = futex */
	{
		ns(struct sys___futex_set_robust_list_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___futex_set_robust_list
	},		/* 99 = __futex_set_robust_list */
	{
		ns(struct sys___futex_get_robust_list_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___futex_get_robust_list
	},		/* 100 = __futex_get_robust_list */
	{
		ns(struct linux_sys_nanosleep_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_nanosleep
	},		/* 101 = nanosleep */
	{
		ns(struct compat_50_sys_getitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_getitimer
	},		/* 102 = getitimer */
	{
		ns(struct compat_50_sys_setitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_setitimer
	},		/* 103 = setitimer */
	{
		.sy_call = linux_sys_nosys,
	},		/* 104 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 105 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 106 = filler */
	{
		ns(struct linux_sys_timer_create_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_timer_create
	},		/* 107 = timer_create */
	{
		ns(struct linux_sys_timer_gettime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_timer_gettime
	},		/* 108 = timer_gettime */
	{
		ns(struct sys_timer_getoverrun_args),
		.sy_call = (sy_call_t *)sys_timer_getoverrun
	},		/* 109 = timer_getoverrun */
	{
		ns(struct linux_sys_timer_settime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_timer_settime
	},		/* 110 = timer_settime */
	{
		ns(struct sys_timer_delete_args),
		.sy_call = (sy_call_t *)sys_timer_delete
	},		/* 111 = timer_delete */
	{
		ns(struct linux_sys_clock_settime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_settime
	},		/* 112 = clock_settime */
	{
		ns(struct linux_sys_clock_gettime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_gettime
	},		/* 113 = clock_gettime */
	{
		ns(struct linux_sys_clock_getres_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_getres
	},		/* 114 = clock_getres */
	{
		ns(struct linux_sys_clock_nanosleep_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_nanosleep
	},		/* 115 = clock_nanosleep */
	{
		.sy_call = linux_sys_nosys,
	},		/* 116 = filler */
	{
		ns(struct linux_sys_ptrace_args),
		.sy_call = (sy_call_t *)linux_sys_ptrace
	},		/* 117 = ptrace */
	{
		ns(struct linux_sys_sched_setparam_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setparam
	},		/* 118 = sched_setparam */
	{
		ns(struct linux_sys_sched_setscheduler_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setscheduler
	},		/* 119 = sched_setscheduler */
	{
		ns(struct linux_sys_sched_getscheduler_args),
		.sy_call = (sy_call_t *)linux_sys_sched_getscheduler
	},		/* 120 = sched_getscheduler */
	{
		ns(struct linux_sys_sched_getparam_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_getparam
	},		/* 121 = sched_getparam */
	{
		ns(struct linux_sys_sched_setaffinity_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setaffinity
	},		/* 122 = sched_setaffinity */
	{
		ns(struct linux_sys_sched_getaffinity_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_getaffinity
	},		/* 123 = sched_getaffinity */
	{
		.sy_call = (sy_call_t *)linux_sys_sched_yield
	},		/* 124 = sched_yield */
	{
		ns(struct linux_sys_sched_get_priority_max_args),
		.sy_call = (sy_call_t *)linux_sys_sched_get_priority_max
	},		/* 125 = sched_get_priority_max */
	{
		ns(struct linux_sys_sched_get_priority_min_args),
		.sy_call = (sy_call_t *)linux_sys_sched_get_priority_min
	},		/* 126 = sched_get_priority_min */
	{
		.sy_call = linux_sys_nosys,
	},		/* 127 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 128 = filler */
	{
		ns(struct linux_sys_kill_args),
		.sy_call = (sy_call_t *)linux_sys_kill
	},		/* 129 = kill */
	{
		ns(struct linux_sys_tkill_args),
		.sy_call = (sy_call_t *)linux_sys_tkill
	},		/* 130 = tkill */
	{
		ns(struct linux_sys_tgkill_args),
		.sy_call = (sy_call_t *)linux_sys_tgkill
	},		/* 131 = tgkill */
	{
		ns(struct linux_sys_sigaltstack_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigaltstack
	},		/* 132 = sigaltstack */
	{
		ns(struct linux_sys_rt_sigsuspend_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigsuspend
	},		/* 133 = rt_sigsuspend */
	{
		ns(struct linux_sys_rt_sigaction_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigaction
	},		/* 134 = rt_sigaction */
	{
		ns(struct linux_sys_rt_sigprocmask_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigprocmask
	},		/* 135 = rt_sigprocmask */
	{
		ns(struct linux_sys_rt_sigpending_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigpending
	},		/* 136 = rt_sigpending */
	{
		ns(struct linux_sys_rt_sigtimedwait_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigtimedwait
	},		/* 137 = rt_sigtimedwait */
	{
		.sy_call = linux_sys_nosys,
	},		/* 138 = filler */
	{
		.sy_call = (sy_call_t *)linux_sys_rt_sigreturn
	},		/* 139 = rt_sigreturn */
	{
		ns(struct sys_setpriority_args),
		.sy_call = (sy_call_t *)sys_setpriority
	},		/* 140 = setpriority */
	{
		ns(struct linux_sys_getpriority_args),
		.sy_call = (sy_call_t *)linux_sys_getpriority
	},		/* 141 = getpriority */
	{
		ns(struct linux_sys_reboot_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_reboot
	},		/* 142 = reboot */
	{
		ns(struct sys_setregid_args),
		.sy_call = (sy_call_t *)sys_setregid
	},		/* 143 = setregid */
	{
		ns(struct sys_setgid_args),
		.sy_call = (sy_call_t *)sys_setgid
	},		/* 144 = setgid */
	{
		ns(struct sys_setreuid_args),
		.sy_call = (sy_call_t *)sys_setreuid
	},		/* 145 = setreuid */
	{
		ns(struct sys_setuid_args),
		.sy_call = (sy_call_t *)sys_setuid
	},		/* 146 = setuid */
	{
		ns(struct linux_sys_setresuid_args),
		.sy_call = (sy_call_t *)linux_sys_setresuid
	},		/* 147 = setresuid */
	{
		ns(struct linux_sys_getresuid_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getresuid
	},		/* 148 = getresuid */
	{
		ns(struct linux_sys_setresgid_args),
		.sy_call = (sy_call_t *)linux_sys_setresgid
	},		/* 149 = setresgid */
	{
		ns(struct linux_sys_getresgid_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getresgid
	},		/* 150 = getresgid */
	{
		ns(struct linux_sys_setfsuid_args),
		.sy_call = (sy_call_t *)linux_sys_setfsuid
	},		/* 151 = setfsuid */
	{
		ns(struct linux_sys_setfsgid_args),
		.sy_call = (sy_call_t *)linux_sys_setfsgid
	},		/* 152 = setfsgid */
	{
		ns(struct linux_sys_times_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_times
	},		/* 153 = times */
	{
		ns(struct sys_setpgid_args),
		.sy_call = (sy_call_t *)sys_setpgid
	},		/* 154 = setpgid */
	{
		ns(struct sys_getpgid_args),
		.sy_call = (sy_call_t *)sys_getpgid
	},		/* 155 = getpgid */
	{
		ns(struct sys_getsid_args),
		.sy_call = (sy_call_t *)sys_getsid
	},		/* 156 = getsid */
	{
		.sy_call = (sy_call_t *)sys_setsid
	},		/* 157 = setsid */
	{
		ns(struct sys_getgroups_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_getgroups
	},		/* 158 = getgroups */
	{
		ns(struct sys_setgroups_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_setgroups
	},		/* 159 = setgroups */
	{
		ns(struct linux_sys_uname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_uname
	},		/* 160 = uname */
	{
		ns(struct compat_43_sys_sethostname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_sethostname
	},		/* 161 = sethostname */
	{
		ns(struct linux_sys_setdomainname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setdomainname
	},		/* 162 = setdomainname */
	{
		ns(struct linux_sys_getrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getrlimit
	},		/* 163 = getrlimit */
	{
		ns(struct linux_sys_setrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setrlimit
	},		/* 164 = setrlimit */
	{
		ns(struct compat_50_sys_getrusage_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_getrusage
	},		/* 165 = getrusage */
	{
		ns(struct sys_umask_args),
		.sy_call = (sy_call_t *)sys_umask
	},		/* 166 = umask */
	{
		ns(struct linux_sys___prctl_args),
		.sy_flags = SYCALL_ARG_PTR | SYCALL_INDIRECT,
		.sy_call = (sy_call_t *)linux_sys___prctl
	},		/* 167 = __prctl */
	{
		ns(struct linux_sys_getcpu_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getcpu
	},		/* 168 = getcpu */
	{
		ns(struct linux_sys_gettimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_gettimeofday
	},		/* 169 = gettimeofday */
	{
		ns(struct linux_sys_settimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_settimeofday
	},		/* 170 = settimeofday */
	{
		.sy_call = linux_sys_nosys,
	},		/* 171 = filler */
	{
		.sy_call = (sy_call_t *)sys_getpid
	},		/* 172 = getpid */
	{
		.sy_call = (sy_call_t *)sys_getppid
	},		/* 173 = getppid */
	{
		.sy_call = (sy_call_t *)sys_getuid
	},		/* 174 = getuid */
	{
		.sy_call = (sy_call_t *)sys_geteuid
	},		/* 175 = geteuid */
	{
		.sy_call = (sy_call_t *)sys_getgid
	},		/* 176 = getgid */
	{
		.sy_call = (sy_call_t *)sys_getegid
	},		/* 177 = getegid */
	{
		.sy_call = (sy_call_t *)linux_sys_gettid
	},		/* 178 = gettid */
	{
		ns(struct linux_sys_sysinfo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sysinfo
	},		/* 179 = sysinfo */
	{
		ns(struct linux_sys_mq_open_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mq_open
	},		/* 180 = mq_open */
	{
		ns(struct linux_sys_mq_unlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mq_unlink
	},		/* 181 = mq_unlink */
	{
		ns(struct linux_sys_mq_timedsend_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mq_timedsend
	},		/* 182 = mq_timedsend */
	{
		ns(struct linux_sys_mq_timedreceive_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mq_timedreceive
	},		/* 183 = mq_timedreceive */
	{
		ns(struct linux_sys_mq_notify_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mq_notify
	},		/* 184 = mq_notify */
	{
		ns(struct linux_sys_mq_getsetattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mq_getsetattr
	},		/* 185 = mq_getsetattr */
#ifdef SYSVMSG
	{
		ns(struct sys_msgget_args),
		.sy_call = (sy_call_t *)sys_msgget
	},		/* 186 = msgget */
	{
		ns(struct linux_sys_msgctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_msgctl
	},		/* 187 = msgctl */
	{
		ns(struct sys_msgrcv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_msgrcv
	},		/* 188 = msgrcv */
	{
		ns(struct sys_msgsnd_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_msgsnd
	},		/* 189 = msgsnd */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 186 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 187 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 188 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 189 = filler */
#endif
#ifdef SYSVSEM
	{
		ns(struct sys_semget_args),
		.sy_call = (sy_call_t *)sys_semget
	},		/* 190 = semget */
	{
		ns(struct linux_sys_semctl_args),
		.sy_call = (sy_call_t *)linux_sys_semctl
	},		/* 191 = semctl */
	{
		ns(struct linux_sys_semtimedop_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_semtimedop
	},		/* 192 = semtimedop */
	{
		ns(struct sys_semop_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_semop
	},		/* 193 = semop */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 190 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 191 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 192 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 193 = filler */
#endif
#ifdef SYSVSEM
	{
		ns(struct linux_sys_shmget_args),
		.sy_call = (sy_call_t *)linux_sys_shmget
	},		/* 194 = shmget */
	{
		ns(struct linux_sys_shmctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_shmctl
	},		/* 195 = shmctl */
	{
		ns(struct sys_shmat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_shmat
	},		/* 196 = shmat */
	{
		ns(struct sys_shmdt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_shmdt
	},		/* 197 = shmdt */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 194 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 195 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 196 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 197 = filler */
#endif
	{
		ns(struct linux_sys_socket_args),
		.sy_call = (sy_call_t *)linux_sys_socket
	},		/* 198 = socket */
	{
		ns(struct linux_sys_socketpair_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_socketpair
	},		/* 199 = socketpair */
	{
		ns(struct linux_sys_bind_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_bind
	},		/* 200 = bind */
	{
		ns(struct sys_listen_args),
		.sy_call = (sy_call_t *)sys_listen
	},		/* 201 = listen */
	{
		ns(struct linux_sys_accept_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_accept
	},		/* 202 = oaccept */
	{
		ns(struct linux_sys_connect_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_connect
	},		/* 203 = connect */
	{
		ns(struct linux_sys_getsockname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getsockname
	},		/* 204 = getsockname */
	{
		ns(struct linux_sys_getpeername_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getpeername
	},		/* 205 = getpeername */
	{
		ns(struct linux_sys_sendto_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sendto
	},		/* 206 = sendto */
	{
		ns(struct linux_sys_recvfrom_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recvfrom
	},		/* 207 = recvfrom */
	{
		ns(struct linux_sys_setsockopt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setsockopt
	},		/* 208 = setsockopt */
	{
		ns(struct linux_sys_getsockopt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getsockopt
	},		/* 209 = getsockopt */
	{
		ns(struct sys_shutdown_args),
		.sy_call = (sy_call_t *)sys_shutdown
	},		/* 210 = shutdown */
	{
		ns(struct linux_sys_sendmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sendmsg
	},		/* 211 = sendmsg */
	{
		ns(struct linux_sys_recvmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recvmsg
	},		/* 212 = recvmsg */
	{
		ns(struct linux_sys_readahead_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64,
		.sy_call = (sy_call_t *)linux_sys_readahead
	},		/* 213 = readahead */
	{
		ns(struct linux_sys_brk_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_brk
	},		/* 214 = brk */
	{
		ns(struct sys_munmap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_munmap
	},		/* 215 = munmap */
	{
		ns(struct linux_sys_mremap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mremap
	},		/* 216 = mremap */
	{
		.sy_call = linux_sys_nosys,
	},		/* 217 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 218 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 219 = filler */
	{
		ns(struct linux_sys_clone_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clone
	},		/* 220 = clone */
	{
		ns(struct sys_execve_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_execve
	},		/* 221 = execve */
	{
		ns(struct linux_sys_mmap_args),
		.sy_call = (sy_call_t *)linux_sys_mmap
	},		/* 222 = mmap */
	{
		ns(struct linux_sys_fadvise64_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64,
		.sy_call = (sy_call_t *)linux_sys_fadvise64
	},		/* 223 = fadvise64 */
	{
		ns(struct linux_sys_swapon_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_swapon
	},		/* 224 = swapon */
	{
		ns(struct linux_sys_swapoff_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_swapoff
	},		/* 225 = swapoff */
	{
		ns(struct linux_sys_mprotect_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mprotect
	},		/* 226 = mprotect */
	{
		ns(struct sys___msync13_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___msync13
	},		/* 227 = __msync13 */
	{
		ns(struct sys_mlock_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mlock
	},		/* 228 = mlock */
	{
		ns(struct sys_munlock_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_munlock
	},		/* 229 = munlock */
	{
		ns(struct sys_mlockall_args),
		.sy_call = (sy_call_t *)sys_mlockall
	},		/* 230 = mlockall */
	{
		.sy_call = (sy_call_t *)sys_munlockall
	},		/* 231 = munlockall */
	{
		ns(struct sys_mincore_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mincore
	},		/* 232 = mincore */
	{
		ns(struct sys_madvise_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_madvise
	},		/* 233 = madvise */
	{
		.sy_call = linux_sys_nosys,
	},		/* 234 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 235 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 236 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 237 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 238 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 239 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 240 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 241 = filler */
	{
		ns(struct linux_sys_accept4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_accept4
	},		/* 242 = accept4 */
	{
		ns(struct linux_sys_recvmmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recvmmsg
	},		/* 243 = recvmmsg */
	{
		.sy_call = linux_sys_nosys,
	},		/* 244 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 245 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 246 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 247 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 248 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 249 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 250 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 251 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 252 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 253 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 254 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 255 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 256 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 257 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 258 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 259 = filler */
	{
		ns(struct linux_sys_wait4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_wait4
	},		/* 260 = wait4 */
	{
		ns(struct linux_sys_prlimit64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_prlimit64
	},		/* 261 = prlimit64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 262 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 263 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 264 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 265 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 266 = filler */
	{
		ns(struct linux_sys_syncfs_args),
		.sy_call = (sy_call_t *)linux_sys_syncfs
	},		/* 267 = syncfs */
	{
		.sy_call = linux_sys_nosys,
	},		/* 268 = filler */
	{
		ns(struct linux_sys_sendmmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sendmmsg
	},		/* 269 = sendmmsg */
	{
		.sy_call = linux_sys_nosys,
	},		/* 270 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 271 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 272 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 273 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 274 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 275 = filler */
	{
		ns(struct linux_sys_renameat2_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_renameat2
	},		/* 276 = renameat2 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 277 = filler */
	{
		ns(struct sys_getrandom_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_getrandom
	},		/* 278 = getrandom */
	{
		ns(struct linux_sys_memfd_create_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_memfd_create
	},		/* 279 = memfd_create */
	{
		.sy_call = linux_sys_nosys,
	},		/* 280 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 281 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 282 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 283 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 284 = filler */
	{
		ns(struct linux_sys_copy_file_range_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_copy_file_range
	},		/* 285 = copy_file_range */
	{
		.sy_call = linux_sys_nosys,
	},		/* 286 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 287 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 288 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 289 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 290 = filler */
	{
		ns(struct linux_sys_statx_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_statx
	},		/* 291 = statx */
	{
		.sy_call = linux_sys_nosys,
	},		/* 292 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 293 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 294 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 295 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 296 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 297 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 298 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 299 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 300 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 301 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 302 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 303 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 304 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 305 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 306 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 307 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 308 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 309 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 310 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 311 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 312 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 313 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 314 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 315 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 316 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 317 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 318 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 319 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 320 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 321 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 322 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 323 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 324 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 325 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 326 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 327 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 328 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 329 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 330 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 331 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 332 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 333 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 334 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 335 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 336 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 337 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 338 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 339 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 340 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 341 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 342 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 343 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 344 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 345 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 346 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 347 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 348 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 349 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 350 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 351 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 352 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 353 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 354 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 355 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 356 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 357 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 358 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 359 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 360 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 361 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 362 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 363 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 364 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 365 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 366 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 367 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 368 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 369 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 370 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 371 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 372 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 373 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 374 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 375 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 376 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 377 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 378 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 379 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 380 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 381 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 382 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 383 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 384 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 385 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 386 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 387 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 388 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 389 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 390 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 391 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 392 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 393 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 394 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 395 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 396 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 397 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 398 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 399 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 400 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 401 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 402 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 403 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 404 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 405 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 406 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 407 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 408 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 409 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 410 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 411 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 412 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 413 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 414 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 415 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 416 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 417 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 418 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 419 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 420 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 421 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 422 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 423 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 424 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 425 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 426 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 427 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 428 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 429 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 430 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 431 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 432 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 433 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 434 = filler */
	{
		ns(struct linux_sys_clone3_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clone3
	},		/* 435 = clone3 */
	{
		ns(struct linux_sys_close_range_args),
		.sy_call = (sy_call_t *)linux_sys_close_range
	},		/* 436 = close_range */
	{
		.sy_call = linux_sys_nosys,
	},		/* 437 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 438 = filler */
	{
		ns(struct linux_sys_faccessat2_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_faccessat2
	},		/* 439 = faccessat2 */
	{
		.sy_call = (sy_call_t *)linux_sys_nosys
	},		/* 440 = nosys */
	{
		ns(struct linux_sys_epoll_pwait2_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_epoll_pwait2
	},		/* 441 = epoll_pwait2 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 442 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 443 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 444 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 445 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 446 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 447 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 448 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 449 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 450 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 451 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 452 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 453 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 454 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 455 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 456 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 457 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 458 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 459 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 460 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 461 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 462 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 463 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 464 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 465 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 466 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 467 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 468 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 469 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 470 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 471 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 472 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 473 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 474 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 475 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 476 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 477 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 478 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 479 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 480 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 481 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 482 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 483 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 484 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 485 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 486 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 487 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 488 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 489 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 490 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 491 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 492 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 493 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 494 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 495 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 496 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 497 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 498 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 499 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 500 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 501 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 502 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 503 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 504 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 505 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 506 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 507 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 508 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 509 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 510 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 511 = filler */
};

const uint32_t linux_sysent_nomodbits[] = {
	0x00000000,	/* syscalls   0- 31 */
	0x00000000,	/* syscalls  32- 63 */
	0x00000000,	/* syscalls  64- 95 */
	0x00000000,	/* syscalls  96-127 */
	0x00000000,	/* syscalls 128-159 */
	0x00000000,	/* syscalls 160-191 */
	0x00000000,	/* syscalls 192-223 */
	0x00000000,	/* syscalls 224-255 */
	0x00000000,	/* syscalls 256-287 */
	0x00000000,	/* syscalls 288-319 */
	0x00000000,	/* syscalls 320-351 */
	0x00000000,	/* syscalls 352-383 */
	0x00000000,	/* syscalls 384-415 */
	0x00000000,	/* syscalls 416-447 */
	0x00000000,	/* syscalls 448-479 */
	0x00000000,	/* syscalls 480-511 */
};
