/*	$NetBSD: spi_calls.h,v 1.2 2025/09/14 16:00:26 thorpej Exp $	*/

/*
 * THIS FILE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.
 *
 * generated from:
 *	NetBSD: spi_calls,v 1.2 2025/09/14 16:00:04 thorpej Exp
 */

/*-
 * Copyright (c) 2021 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Device calls used by the SPI subsystem.
 */

#ifndef _SPI_CALLS_H_
#define _SPI_CALLS_H_

#include <sys/device.h>

#include <dev/spi/spivar.h>

/*
 * spi-enumerate-devices
 *
 * Enumerates the devices connected to the SPI bus, filling out
 * the spi_attach_args and invoking the callback for each one.
 * The caller provides the storage for the spi_attach_args.  Because
 * the chip select is not exposed to SPI drivers in spi_attach_args,
 * the chip select provided by the enumeration is captured in the
 * arguments passed to the callback.
 *
 * If the callback returns true, then enumeration continues.  If
 * the callback returns false, enumeration is stopped.
 *
 * Call returns 0 if successful, or an error code upon failure:
 *
 * ENOTSUP	The device handle implementation for the
 *		SPI bus does not support this device call.
 */
struct spi_enumerate_devices_args {
	struct spi_attach_args *sa;	/* IN */
	bool (*callback)(device_t, struct spi_enumerate_devices_args *);
	int chip_select;		/* OUT */
};

union spi_enumerate_devices_binding {
	struct device_call_generic generic;
	struct {
		const char *name;
		struct spi_enumerate_devices_args *args;
	} binding;
};

#define SPI_ENUMERATE_DEVICES_STR "spi-enumerate-devices"

#define SPI_ENUMERATE_DEVICES(_args_) \
	&((const union spi_enumerate_devices_binding){ \
		.binding.name = "spi-enumerate-devices", \
		.binding.args = (_args_), \
	})

/*
 * spi-get-transfer-mode
 *
 * Gets the transfer mode associated with the specified device handle
 * from the device tree.
 *
 * Call returns 0 if successful, or an error code upon failure:
 *
 * ENOTSUP	The device handle implementation for the
 *		SPI bus does not support this device call.
 *
 * EINVAL	The transfer mode information associated with the
 *		device handle is invalid.
 */
struct spi_get_transfer_mode_args {
	unsigned int mode;		/* OUT */
	unsigned int max_frequency;	/* OUT */
	unsigned int flags;		/* OUT */
	unsigned int cs_setup_delay_ns;	/* OUT */
	unsigned int cs_hold_delay_ns;	/* OUT */
	unsigned int cs_inact_delay_ns;	/* OUT */
	unsigned int rx_bus_width;	/* OUT */
	unsigned int rx_delay_us;	/* OUT */
	unsigned int rx_sample_delay_ns;/* OUT */
	unsigned int tx_bus_width;	/* OUT */
	unsigned int tx_delay_us;	/* OUT */
};

union spi_get_transfer_mode_binding {
	struct device_call_generic generic;
	struct {
		const char *name;
		struct spi_get_transfer_mode_args *args;
	} binding;
};

#define SPI_GET_TRANSFER_MODE_STR "spi-get-transfer-mode"

#define SPI_GET_TRANSFER_MODE(_args_) \
	&((const union spi_get_transfer_mode_binding){ \
		.binding.name = "spi-get-transfer-mode", \
		.binding.args = (_args_), \
	})

#endif /* _SPI_CALLS_H_ */
