/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.HashMap;
import org.postgresql.pljava.TransactionListener;
import org.postgresql.pljava.internal.Backend;

class XactListener {
    private static final HashMap s_listeners = new HashMap();

    XactListener() {
    }

    static void onAbort(long listenerId) throws SQLException {
        TransactionListener listener = (TransactionListener)s_listeners.get(new Long(listenerId));
        if (listener != null) {
            listener.onAbort(Backend.getSession());
        }
    }

    static void onCommit(long listenerId) throws SQLException {
        TransactionListener listener = (TransactionListener)s_listeners.get(new Long(listenerId));
        if (listener != null) {
            listener.onCommit(Backend.getSession());
        }
    }

    static void onPrepare(long listenerId) throws SQLException {
        TransactionListener listener = (TransactionListener)s_listeners.get(new Long(listenerId));
        if (listener != null) {
            listener.onPrepare(Backend.getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addListener(TransactionListener listener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long key = System.identityHashCode(listener);
            if (s_listeners.put(new Long(key), listener) != listener) {
                XactListener._register(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeListener(TransactionListener listener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long key = System.identityHashCode(listener);
            if (s_listeners.remove(new Long(key)) == listener) {
                XactListener._unregister(key);
            }
        }
    }

    private static native void _register(long var0);

    private static native void _unregister(long var0);
}

