/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.ObjectResultSet;
import org.postgresql.pljava.jdbc.SPIResultSetMetaData;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public abstract class SingleRowResultSet
extends ObjectResultSet {
    @Override
    public int getConcurrency() throws SQLException {
        return 1008;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.getTupleDesc().getColumnIndex(columnName);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 1;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new SPIResultSetMetaData(this.getTupleDesc());
    }

    @Override
    public int getRow() throws SQLException {
        return 1;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public void afterLast() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    @Override
    public boolean first() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return true;
    }

    @Override
    public boolean isLast() throws SQLException {
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    @Override
    public boolean next() throws SQLException {
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new UnsupportedFeatureException("Non forward fetch direction");
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        if (fetchSize != 1) {
            throw new IllegalArgumentException("Illegal fetch size for single row set");
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedFeatureException("Deletes not supported on single row set");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedFeatureException("Inserts not supported on single row set");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedFeatureException("Inserts not supported on single row set");
    }

    @Override
    public void updateRow() throws SQLException {
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    @Override
    public int getHoldability() {
        return 2;
    }

    protected abstract TupleDesc getTupleDesc() throws SQLException;
}

