/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.AbstractMavenFilteringRequest;
import org.apache.maven.shared.filtering.FilteringUtils;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MultiDelimiterInterpolatorFilterReaderLineEnding;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.SingleResponseValueSource;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.interpolation.multi.MultiDelimiterStringSearchInterpolator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMavenFileFilter
extends AbstractLogEnabled
implements MavenFileFilter {
    private BuildContext buildContext;

    @Override
    public void copyFile(File from, File to, boolean filtering, MavenProject mavenProject, List<String> filters, boolean escapedBackslashesInFilePath, String encoding, MavenSession mavenSession) throws MavenFilteringException {
        MavenResourcesExecution mre = new MavenResourcesExecution();
        mre.setMavenProject(mavenProject);
        mre.setFileFilters(filters);
        mre.setEscapeWindowsPaths(escapedBackslashesInFilePath);
        mre.setMavenSession(mavenSession);
        mre.setInjectProjectBuildFilters(true);
        List<FileUtils.FilterWrapper> filterWrappers = this.getDefaultFilterWrappers(mre);
        this.copyFile(from, to, filtering, filterWrappers, encoding);
    }

    @Override
    public void copyFile(MavenFileFilterRequest mavenFileFilterRequest) throws MavenFilteringException {
        List<FileUtils.FilterWrapper> filterWrappers = this.getDefaultFilterWrappers(mavenFileFilterRequest);
        this.copyFile(mavenFileFilterRequest.getFrom(), mavenFileFilterRequest.getTo(), mavenFileFilterRequest.isFiltering(), filterWrappers, mavenFileFilterRequest.getEncoding());
    }

    @Override
    public void copyFile(File from, File to, boolean filtering, List<FileUtils.FilterWrapper> filterWrappers, String encoding) throws MavenFilteringException {
        this.copyFile(from, to, filtering, filterWrappers, encoding, false);
    }

    @Override
    public void copyFile(File from, File to, boolean filtering, List<FileUtils.FilterWrapper> filterWrappers, String encoding, boolean overwrite) throws MavenFilteringException {
        try {
            if (filtering) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("filtering " + from.getPath() + " to " + to.getPath());
                }
                FileUtils.FilterWrapper[] wrappers = filterWrappers.toArray(new FileUtils.FilterWrapper[filterWrappers.size()]);
                FileUtils.copyFile((File)from, (File)to, (String)encoding, (FileUtils.FilterWrapper[])wrappers);
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("copy " + from.getPath() + " to " + to.getPath());
                }
                FileUtils.copyFile((File)from, (File)to, (String)encoding, (FileUtils.FilterWrapper[])new FileUtils.FilterWrapper[0], (boolean)overwrite);
            }
            this.buildContext.refresh(to);
        }
        catch (IOException e) {
            throw new MavenFilteringException(e.getMessage(), e);
        }
    }

    @Override
    public List<FileUtils.FilterWrapper> getDefaultFilterWrappers(MavenProject mavenProject, List<String> filters, boolean escapedBackslashesInFilePath, MavenSession mavenSession) throws MavenFilteringException {
        return this.getDefaultFilterWrappers(mavenProject, filters, escapedBackslashesInFilePath, mavenSession, null);
    }

    @Override
    public List<FileUtils.FilterWrapper> getDefaultFilterWrappers(MavenProject mavenProject, List<String> filters, boolean escapedBackslashesInFilePath, MavenSession mavenSession, MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        MavenResourcesExecution mre = mavenResourcesExecution == null ? new MavenResourcesExecution() : mavenResourcesExecution.copyOf();
        mre.setMavenProject(mavenProject);
        mre.setMavenSession(mavenSession);
        mre.setFilters(filters);
        mre.setEscapedBackslashesInFilePath(escapedBackslashesInFilePath);
        return this.getDefaultFilterWrappers(mre);
    }

    @Override
    public List<FileUtils.FilterWrapper> getDefaultFilterWrappers(AbstractMavenFilteringRequest req) throws MavenFilteringException {
        ArrayList<FileUtils.FilterWrapper> defaultFilterWrappers;
        boolean supportMultiLineFiltering = req.isSupportMultiLineFiltering();
        AbstractMavenFilteringRequest request = req == null ? new MavenFileFilterRequest() : req;
        request.setSupportMultiLineFiltering(supportMultiLineFiltering);
        Properties baseProps = new Properties();
        if (request.getMavenProject() != null) {
            baseProps.putAll((Map<?, ?>)(request.getMavenProject().getProperties() == null ? Collections.emptyMap() : request.getMavenProject().getProperties()));
        }
        if (request.getMavenSession() != null) {
            baseProps.putAll((Map<?, ?>)request.getMavenSession().getExecutionProperties());
        }
        Properties filterProperties = new Properties();
        File basedir = request.getMavenProject() != null ? request.getMavenProject().getBasedir() : new File(".");
        this.loadProperties(filterProperties, basedir, request.getFileFilters(), baseProps);
        if (filterProperties.size() < 1) {
            filterProperties.putAll((Map<?, ?>)baseProps);
        }
        if (request.getMavenProject() != null) {
            if (request.isInjectProjectBuildFilters()) {
                ArrayList<String> buildFilters = new ArrayList<String>(request.getMavenProject().getBuild().getFilters());
                if (request.getFileFilters() != null) {
                    buildFilters.removeAll(request.getFileFilters());
                }
                this.loadProperties(filterProperties, basedir, buildFilters, baseProps);
            }
            filterProperties.putAll((Map<?, ?>)(request.getMavenProject().getProperties() == null ? Collections.emptyMap() : request.getMavenProject().getProperties()));
        }
        if (request.getMavenSession() != null) {
            filterProperties.putAll((Map<?, ?>)request.getMavenSession().getExecutionProperties());
        }
        if (request.getAdditionalProperties() != null) {
            filterProperties.putAll((Map<?, ?>)request.getAdditionalProperties());
        }
        ArrayList<Object> arrayList = defaultFilterWrappers = request == null ? new ArrayList<FileUtils.FilterWrapper>(1) : new ArrayList(request.getDelimiters().size() + 1);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("properties used " + filterProperties);
        }
        PropertiesBasedValueSource propertiesValueSource = new PropertiesBasedValueSource(filterProperties);
        if (request != null) {
            Wrapper wrapper = new Wrapper(request.getDelimiters(), request.getMavenProject(), request.getMavenSession(), (ValueSource)propertiesValueSource, request.getProjectStartExpressions(), request.getEscapeString(), request.isEscapeWindowsPaths(), request.isSupportMultiLineFiltering());
            defaultFilterWrappers.add(wrapper);
        }
        return defaultFilterWrappers;
    }

    void loadProperties(Properties filterProperties, File basedir, List<String> propertiesFilePaths, Properties baseProps) throws MavenFilteringException {
        if (propertiesFilePaths != null) {
            Properties workProperties = new Properties();
            workProperties.putAll((Map<?, ?>)baseProps);
            for (String filterFile : propertiesFilePaths) {
                if (StringUtils.isEmpty((String)filterFile)) continue;
                try {
                    File propFile = FileUtils.resolveFile((File)basedir, (String)filterFile);
                    Properties properties = PropertyUtils.loadPropertyFile(propFile, workProperties);
                    filterProperties.putAll((Map<?, ?>)properties);
                    workProperties.putAll((Map<?, ?>)properties);
                }
                catch (IOException e) {
                    throw new MavenFilteringException("Error loading property file '" + filterFile + "'", e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Wrapper
    extends FileUtils.FilterWrapper {
        private LinkedHashSet<String> delimiters;
        private MavenProject project;
        private ValueSource propertiesValueSource;
        private List<String> projectStartExpressions;
        private String escapeString;
        private boolean escapeWindowsPaths;
        private final MavenSession mavenSession;
        private boolean supportMultiLineFiltering;

        Wrapper(LinkedHashSet<String> delimiters, MavenProject project, MavenSession mavenSession, ValueSource propertiesValueSource, List<String> projectStartExpressions, String escapeString, boolean escapeWindowsPaths, boolean supportMultiLineFiltering) {
            this.delimiters = delimiters;
            this.project = project;
            this.mavenSession = mavenSession;
            this.propertiesValueSource = propertiesValueSource;
            this.projectStartExpressions = projectStartExpressions;
            this.escapeString = escapeString;
            this.escapeWindowsPaths = escapeWindowsPaths;
            this.supportMultiLineFiltering = supportMultiLineFiltering;
        }

        public Reader getReader(Reader reader) {
            MultiDelimiterStringSearchInterpolator interpolator = new MultiDelimiterStringSearchInterpolator();
            interpolator.setDelimiterSpecs(this.delimiters);
            Object ri = null;
            ri = this.projectStartExpressions != null && !this.projectStartExpressions.isEmpty() ? new PrefixAwareRecursionInterceptor(this.projectStartExpressions, true) : new SimpleRecursionInterceptor();
            interpolator.addValueSource(this.propertiesValueSource);
            if (this.project != null) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource(this.projectStartExpressions, (Object)this.project, true));
            }
            if (this.mavenSession != null) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("session", (Object)this.mavenSession));
                Settings settings = this.mavenSession.getSettings();
                if (settings != null) {
                    interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("settings", (Object)settings));
                    interpolator.addValueSource((ValueSource)new SingleResponseValueSource("localRepository", (Object)settings.getLocalRepository()));
                }
            }
            interpolator.setEscapeString(this.escapeString);
            if (this.escapeWindowsPaths) {
                interpolator.addPostProcessor(new InterpolationPostProcessor(){

                    public Object execute(String expression, Object value) {
                        if (value instanceof String) {
                            return FilteringUtils.escapeWindowsPath((String)value);
                        }
                        return value;
                    }
                });
            }
            MultiDelimiterInterpolatorFilterReaderLineEnding filterReader = new MultiDelimiterInterpolatorFilterReaderLineEnding(reader, (Interpolator)interpolator, this.supportMultiLineFiltering);
            filterReader.setRecursionInterceptor((RecursionInterceptor)ri);
            filterReader.setDelimiterSpecs(this.delimiters);
            filterReader.setInterpolateWithPrefixPattern(false);
            filterReader.setEscapeString(this.escapeString);
            return filterReader;
        }
    }
}

