/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import org.postgresql.pljava.ResultSetProvider;

public class MetaDataBooleans
implements ResultSetProvider {
    String[] methodNames;
    Boolean[] methodResults;

    public static ResultSetProvider getDatabaseMetaDataBooleans() throws SQLException {
        try {
            return new MetaDataBooleans();
        }
        catch (SQLException e) {
            throw new SQLException("Error reading DatabaseMetaData", e.getMessage());
        }
    }

    public MetaDataBooleans() throws SQLException {
        Logger log = Logger.getAnonymousLogger();
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        DatabaseMetaData md = conn.getMetaData();
        Method[] m = DatabaseMetaData.class.getMethods();
        class MethodComparator
        implements Comparator<Method> {
            MethodComparator() {
            }

            @Override
            public int compare(Method a, Method b) {
                return a.getName().compareTo(b.getName());
            }
        }
        Arrays.sort(m, new MethodComparator());
        Object[] args = new Object[]{};
        Boolean result = null;
        ArrayList<String> mn = new ArrayList<String>();
        ArrayList<Boolean> mr = new ArrayList<Boolean>();
        for (int i = 0; i < m.length; ++i) {
            Class<?> returntype;
            Class<?>[] prototype = m[i].getParameterTypes();
            if (prototype.length > 0 || !(returntype = m[i].getReturnType()).equals(Boolean.TYPE)) continue;
            try {
                result = (Boolean)m[i].invoke((Object)md, args);
            }
            catch (Exception e) {
                log.info("Method: " + m[i].getName() + " => " + e.getMessage());
            }
            catch (AbstractMethodError e) {
                log.info("Method: " + m[i].getName() + " => " + e.getMessage());
            }
            mn.add(m[i].getName());
            mr.add(result);
        }
        this.methodNames = mn.toArray(new String[0]);
        this.methodResults = mr.toArray(new Boolean[0]);
    }

    public boolean assignRowValues(ResultSet receiver, int currentRow) throws SQLException {
        if (currentRow < this.methodNames.length) {
            receiver.updateString(1, this.methodNames[currentRow]);
            receiver.updateBoolean(2, (boolean)this.methodResults[currentRow]);
            return true;
        }
        return false;
    }

    public void close() {
    }
}

