/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.compiler;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.LinkerParam;
import com.github.maven_nar.cpptasks.ProcessorParam;
import com.github.maven_nar.cpptasks.TargetInfo;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.LinkerConfiguration;
import org.apache.tools.ant.BuildException;

public final class CommandLineLinkerConfiguration
implements LinkerConfiguration {
    private String[][] args;
    private String identifier;
    private String[] libraryNames;
    private CommandLineLinker linker;
    private boolean map;
    private ProcessorParam[] params;
    private boolean rebuild;
    private String commandPath;
    private boolean debug;
    private String startupObject;

    public CommandLineLinkerConfiguration(CommandLineLinker linker, String identifier, String[][] args, ProcessorParam[] params, boolean rebuild, boolean map, boolean debug, String[] libraryNames, String startupObject) {
        this(linker, identifier, args, params, rebuild, map, debug, libraryNames, startupObject, null);
    }

    public CommandLineLinkerConfiguration(CommandLineLinker linker, String identifier, String[][] args, ProcessorParam[] params, boolean rebuild, boolean map, boolean debug, String[] libraryNames, String startupObject, String commandPath) {
        if (linker == null) {
            throw new NullPointerException("linker");
        }
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = (String[][])args.clone();
        this.linker = linker;
        this.params = (ProcessorParam[])params.clone();
        this.rebuild = rebuild;
        this.identifier = identifier;
        this.map = map;
        this.debug = debug;
        this.libraryNames = libraryNames == null ? new String[0] : (String[])libraryNames.clone();
        this.startupObject = startupObject;
        this.commandPath = commandPath;
    }

    @Override
    public int bid(String filename) {
        return this.linker.bid(filename);
    }

    public String[] getEndArguments() {
        String[] clone = (String[])this.args[1].clone();
        return clone;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getLibraryNames() {
        String[] clone = (String[])this.libraryNames.clone();
        return clone;
    }

    public boolean getMap() {
        return this.map;
    }

    @Override
    public String[] getOutputFileNames(String inputFile, VersionInfo versionInfo) {
        return this.linker.getOutputFileNames(inputFile, versionInfo);
    }

    @Override
    public LinkerParam getParam(String name) {
        for (int i = 0; i < this.params.length; ++i) {
            if (!name.equals(this.params[i].getName())) continue;
            return (LinkerParam)this.params[i];
        }
        return null;
    }

    @Override
    public ProcessorParam[] getParams() {
        return this.params;
    }

    public String[] getPreArguments() {
        String[] clone = (String[])this.args[0].clone();
        return clone;
    }

    @Override
    public boolean getRebuild() {
        return this.rebuild;
    }

    public String getStartupObject() {
        return this.startupObject;
    }

    @Override
    public void link(CCTask task, TargetInfo linkTarget) throws BuildException {
        String[] sourcePaths = linkTarget.getAllSourcePaths();
        this.linker.link(task, linkTarget.getOutput(), sourcePaths, this);
    }

    public String toString() {
        return this.identifier;
    }

    @Override
    public Linker getLinker() {
        return this.linker;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public final void setCommandPath(String commandPath) {
        this.commandPath = commandPath;
    }

    public final String getCommandPath() {
        return this.commandPath;
    }
}

